/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.conditions;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.conditions.Condition;

public class ConditionPlayerCanSweep
extends Condition {
    private final boolean _val;
    private static final int maxSweepTime = 15000;

    public ConditionPlayerCanSweep(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        boolean canSweep;
        boolean bl = canSweep = env.player != null && env.player instanceof L2PcInstance;
        if (canSweep) {
            L2Object[] targets;
            L2PcInstance sweeper = env.player.getActingPlayer();
            L2Skill sweep = env.skill;
            if ((canSweep &= sweep != null) && (canSweep &= (targets = sweep.getTargetList(sweeper)) != null)) {
                for (L2Object objTarget : targets) {
                    L2Attackable target;
                    if (!(canSweep &= objTarget != null && objTarget instanceof L2Attackable) || !(canSweep &= (target = (L2Attackable)objTarget).isDead())) continue;
                    if (canSweep &= target.isSpoil()) {
                        canSweep &= target.checkSpoilOwner(sweeper, true);
                        canSweep &= target.checkCorpseTime(sweeper, 15000, true);
                        canSweep &= sweeper.getInventory().checkInventorySlotsAndWeight(target.getSpoilLootItems(), true, true);
                        continue;
                    }
                    sweeper.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SWEEPER_FAILED_TARGET_NOT_SPOILED));
                }
            }
        }
        return this._val == canSweep;
    }
}

