/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.templates.StatsSet;

public class L2SkillElemental
extends L2Skill {
    private final int[] _seeds = new int[3];
    private final boolean _seedAny;

    public L2SkillElemental(StatsSet set) {
        super(set);
        this._seeds[0] = set.getInteger("seed1", 0);
        this._seeds[1] = set.getInteger("seed2", 0);
        this._seeds[2] = set.getInteger("seed3", 0);
        this._seedAny = set.getInteger("seed_any", 0) == 1;
    }

    @Override
    public void useSkill(L2Character activeChar, L2Object[] targets) {
        if (activeChar.isAlikeDead()) {
            return;
        }
        boolean ss = false;
        boolean bss = false;
        L2ItemInstance weaponInst = activeChar.getActiveWeaponInstance();
        if (weaponInst != null) {
            if (weaponInst.getChargedSpiritshot() == 2) {
                bss = true;
                weaponInst.setChargedSpiritshot(0);
            } else if (weaponInst.getChargedSpiritshot() == 1) {
                ss = true;
                weaponInst.setChargedSpiritshot(0);
            }
        } else if (activeChar instanceof L2Summon) {
            L2Summon activeSummon = (L2Summon)activeChar;
            if (activeSummon.getChargedSpiritShot() == 2) {
                bss = true;
                activeSummon.setChargedSpiritShot(0);
            } else if (activeSummon.getChargedSpiritShot() == 1) {
                ss = true;
                activeSummon.setChargedSpiritShot(0);
            }
        }
        for (L2Character target : (L2Character[])targets) {
            int i;
            if (target.isAlikeDead()) continue;
            boolean charged = true;
            if (!this._seedAny) {
                for (i = 0; i < this._seeds.length; ++i) {
                    L2Effect e;
                    if (this._seeds[i] == 0 || (e = target.getFirstEffect(this._seeds[i])) != null && e.getInUse()) continue;
                    charged = false;
                    break;
                }
            } else {
                charged = false;
                for (i = 0; i < this._seeds.length; ++i) {
                    L2Effect e;
                    if (this._seeds[i] == 0 || (e = target.getFirstEffect(this._seeds[i])) == null || !e.getInUse()) continue;
                    charged = true;
                    break;
                }
            }
            if (!charged) {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED).addSkillName(this.getDisplayId()));
                continue;
            }
            boolean mcrit = Formulas.calcMCrit(activeChar.getMCriticalHit(target, this));
            byte shld = Formulas.calcShldUse(activeChar, target, this);
            int damage = (int)Formulas.calcMagicDam(activeChar, target, this, shld, ss, bss, mcrit);
            if (damage > 0) {
                target.reduceCurrentHp(damage, activeChar, this);
                if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                    target.breakAttack();
                    target.breakCast();
                }
                activeChar.sendDamageMessage(target, damage, false, false, false);
            }
            target.stopSkillEffects(this.getId());
            this.getEffects(activeChar, target, new Env(shld, ss, false, bss));
        }
    }
}

