﻿## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/castlename-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open SQL, '>:utf8', 'castlename_ja.sql'  or die $!;
print SQL "--
-- from 'castlename-j.dat'
--
DROP TABLE IF EXISTS castlename_ja;
CREATE TABLE castlename_ja (
	 id INTEGER NOT NULL
	,name VARCHAR(200) DEFAULT ''
	,locName VARCHAR(100) DEFAULT ''
	,`desc` VARCHAR(100) DEFAULT ''
	,PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

";

my $count = 0;
my $delim = ' ';
<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//}
	my ($id,$name,$locName,$desc) = ($field[2],$field[3],$field[4],$field[5]);
	$name =~ s/^$locName //;	#'アデン ゴールデン ラウンジ'⇒'ゴールデン ラウンジ'
	$name =~ s/'/''/g;
	$locName =~ s/'/''/g;
	$desc =~ s/'/''/g;
	print "$id\r";

	if (++$count > 500) {
		print SQL ";\n";
		$count = 1;
	}
	if ($count == 1) {
		print SQL "INSERT INTO castlename_ja (id,name,locName,`desc`) VALUES\n";
		$delim = ' ';
	}
	print SQL $delim,"($id,'$name','$locName','$desc')\n";
	$delim = ',';
}
print SQL ";\n";
print SQL "
-- Update for Japanese.

UPDATE clanhall,castlename_ja SET
  clanhall.name = castlename_ja.name
 WHERE clanhall.id = castlename_ja.id;

UPDATE clanhall,castlename_ja SET
  clanhall.desc = castlename_ja.desc
 WHERE clanhall.id = castlename_ja.id AND castlename_ja.desc <> '';

UPDATE clanhall SET `desc`='占領型のアジト' WHERE `desc`='Contestable Clan Hall';

UPDATE auction,castlename_ja SET
  auction.itemName = castlename_ja.name
 WHERE auction.id = castlename_ja.id;

-- DROP TABLE castlename_ja;
";
close SQL;
utime $mtime,$mtime,'castlename_ja.sql';

close CSV;
print "\n";

__END__

むやみに日本語化すると動作しなくなる箇所

フィールド castle.name
影響箇所 com.l2jserver.gameserver.model.entity.Castle.addToTreasury(...)
  if (_name.equalsIgnoreCase("Schuttgart") || _name.equalsIgnoreCase("Goddard"))

フィールド clanhall.location
影響箇所 com.l2jserver.gameserver.model.actor.instance.L2ClanHallManagerInstance.onBypassFeedback(...)
  html.setFile("data/html/clanHallManager/tele"+getClanHall().getLocation()+getClanHall().getFunction(ClanHall.FUNC_TELEPORT).getLvl()+".htm");
                                                ~~~~~~~~~~~~~~~~~~~~~~~~~~~
  data/html/clanHallManager/tele{???}1.htm がアクセスできなくなる

-- 失敗したので元に戻す。
UPDATE clanhall SET location = 'Dion' WHERE location = 'ディオン';
UPDATE clanhall SET location = 'Gludio' WHERE location = 'グルーディオ';
UPDATE clanhall SET location = 'Gludin' WHERE location = 'グルーディン';
UPDATE clanhall SET location = 'Aden' WHERE location = 'アデン';
UPDATE clanhall SET location = 'Oren' WHERE location = 'オーレン';
UPDATE clanhall SET location = 'Giran' WHERE location = 'ギラン';
UPDATE clanhall SET location = 'Goddard' WHERE location = 'ゴダード';
UPDATE clanhall SET location = 'Rune' WHERE location = 'ルウン';
UPDATE clanhall SET location = 'Schuttgart' WHERE location = 'シュチュッツガルト';
