/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CodeFormatFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.IMultiLineCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFormatCleanUp
extends AbstractCleanUp {
    public CodeFormatCleanUp() {
    }

    public CodeFormatCleanUp(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requiresChangedRegions = this.isEnabled("cleanup.format_source_code") && this.isEnabled("cleanup.format_source_code_changes_only");
        return new CleanUpRequirements(false, false, requiresChangedRegions, null);
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        ICompilationUnit compilationUnit = context.getCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        IRegion[] regions = context instanceof IMultiLineCleanUp.MultiLineCleanUpContext ? ((IMultiLineCleanUp.MultiLineCleanUpContext)context).getRegions() : (IRegion[])null;
        boolean removeWhitespaces = this.isEnabled("cleanup.remove_trailing_whitespaces");
        return CodeFormatFix.createCleanUp(compilationUnit, regions, this.isEnabled("cleanup.format_source_code"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_all"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty"), this.isEnabled("cleanup.correct_indentation"));
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.format_source_code")) {
            result.add(MultiFixMessages.CodeFormatCleanUp_description);
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            if (this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingAll_description);
            } else if (this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingNoEmpty_description);
            }
        }
        if (this.isEnabled("cleanup.correct_indentation")) {
            result.add(MultiFixMessages.CodeFormatCleanUp_correctIndentation_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("/**\n");
        buf.append(" *A Javadoc comment\n");
        buf.append("* @since 2007\n");
        buf.append(" */\n");
        buf.append("public class Engine {\n");
        buf.append("  public void start() {}\n");
        if (this.isEnabled("cleanup.remove_trailing_whitespaces") && this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
            buf.append("\n");
        } else {
            buf.append("    \n");
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            buf.append("    public\n");
        } else {
            buf.append("    public \n");
        }
        buf.append("        void stop() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        return buf.toString();
    }
}

