/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.infoviews.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.infoviews.GotoInputAction;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener,
IPropertyChangeListener {
    private final long TITLE_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private final long LOCAL_VARIABLE_TITLE_FLAGS = this.TITLE_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private final long TYPE_PARAMETER_TITLE_FLAGS = this.TITLE_FLAGS | 0x400000L;
    private static final long TOOLTIP_LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AbstractInfoView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };
    protected IJavaElement fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private GotoInputAction fGotoInputAction;
    private volatile int fComputeCount;
    private IProgressMonitor fComputeProgressMonitor;
    private Color fBackgroundColor;
    private RGB fBackgroundColorRGB;
    private boolean fLinking = true;
    private IJavaElement fLastSelection;

    protected abstract void doSetInput(Object var1);

    protected abstract Object computeInput(Object var1);

    protected Object computeInput(IWorkbenchPart part, ISelection selection, IJavaElement element, IProgressMonitor monitor) {
        return this.computeInput(element);
    }

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    abstract Control getControl();

    protected abstract String getHelpContextId();

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        this.inititalizeColors();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void createActions() {
        this.fGotoInputAction = new GotoInputAction(this);
        this.fGotoInputAction.setEnabled(false);
        this.fCopyToClipboardAction = new CopyToClipboardAction((IWorkbenchSite)this.getViewSite());
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup("group.edit", action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup("group.edit", action);
        }
        menu.appendToGroup("group.open", (IAction)this.fGotoInputAction);
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected IJavaElement getInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fGotoInputAction);
    }

    private void inititalizeColors() {
        Color bgColor;
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        ColorRegistry registry = JFaceResources.getColorRegistry();
        registry.addListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = registry.getRGB(this.getBackgroundColorKey());
        if (this.fBackgroundColorRGB == null) {
            bgColor = display.getSystemColor(29);
            this.fBackgroundColorRGB = bgColor.getRGB();
        } else {
            this.fBackgroundColor = bgColor = new Color((Device)display, this.fBackgroundColorRGB);
        }
        this.setBackground(bgColor);
    }

    protected abstract String getBackgroundColorKey();

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getBackgroundColorKey().equals(event.getProperty())) {
            this.inititalizeColors();
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    protected void setLinkingEnabled(boolean enabled) {
        this.fLinking = enabled;
        if (this.fLinking && this.fLastSelection != null) {
            this.setInput(this.fLastSelection);
        }
    }

    protected boolean isLinkingEnabled() {
        return this.fLinking;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
        if (!this.fLinking) {
            IJavaElement javaElement = this.findSelectedJavaElement(part, selection);
            if (javaElement != null) {
                this.fLastSelection = javaElement;
            }
        } else {
            this.fLastSelection = null;
            this.computeAndSetInput(part);
        }
    }

    protected boolean isIgnoringNewInput(IJavaElement je, IWorkbenchPart part, ISelection selection) {
        return this.fCurrentViewInput != null && this.fCurrentViewInput.equals(je) && je != null;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        Object element;
        block6: {
            block5: {
                try {
                    if (!(part instanceof JavaEditor) || !(selection instanceof ITextSelection)) break block5;
                    IJavaElement[] elements = TextSelectionConverter.codeResolve((JavaEditor)part, (ITextSelection)selection);
                    if (elements != null && elements.length > 0) {
                        return elements[0];
                    }
                    return null;
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            if (selection instanceof IStructuredSelection) {
                element = SelectionUtil.getSingleElement(selection);
                break block6;
            }
            return null;
        }
        return this.findJavaElement(element);
    }

    private IJavaElement findJavaElement(Object element) {
        if (element == null) {
            return null;
        }
        IJavaElement je = null;
        if (element instanceof IAdaptable) {
            je = (IJavaElement)((IAdaptable)element).getAdapter(IJavaElement.class);
        }
        return je;
    }

    protected IType getTypeForCU(ICompilationUnit cu) {
        if (cu == null || !cu.exists()) {
            return null;
        }
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            return primaryType;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public final void dispose() {
        ++this.fComputeCount;
        if (this.fComputeProgressMonitor != null) {
            this.fComputeProgressMonitor.setCanceled(true);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = null;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        this.internalDispose();
    }

    protected abstract void internalDispose();

    private void computeAndSetInput(IWorkbenchPart part) {
        this.computeAndDoSetInput(part, null);
    }

    public final void setInput(IJavaElement element) {
        this.computeAndDoSetInput(null, element);
    }

    private void computeAndDoSetInput(final IWorkbenchPart part, final IJavaElement element) {
        ISelection selection;
        Assert.isLegal((part != null || element != null ? 1 : 0) != 0);
        final int currentCount = ++this.fComputeCount;
        if (element != null) {
            selection = null;
        } else {
            ISelectionProvider provider = part.getSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            selection = provider.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
        }
        if (this.fComputeProgressMonitor != null) {
            this.fComputeProgressMonitor.setCanceled(true);
        }
        NullProgressMonitor computeProgressMonitor = new NullProgressMonitor();
        this.fComputeProgressMonitor = computeProgressMonitor;
        Thread thread = new Thread("Info view input computer", (IProgressMonitor)computeProgressMonitor){
            private final /* synthetic */ IProgressMonitor val$computeProgressMonitor;
            {
                this.val$computeProgressMonitor = iProgressMonitor;
                super($anonymous0);
            }

            public void run() {
                IJavaElement je;
                if (currentCount != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                if (element != null) {
                    je = element;
                } else {
                    je = AbstractInfoView.this.findSelectedJavaElement(part, selection);
                    if (AbstractInfoView.this.isIgnoringNewInput(je, part, selection)) {
                        return;
                    }
                }
                final Object input = AbstractInfoView.this.computeInput(part, selection, je, this.val$computeProgressMonitor);
                if (input == null) {
                    return;
                }
                final String description = AbstractInfoView.this.computeDescription(part, selection, je, this.val$computeProgressMonitor);
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (AbstractInfoView.this.fComputeCount != currentCount || AbstractInfoView.this.getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        (this).AbstractInfoView.this.fCurrentViewInput = je;
                        AbstractInfoView.this.doSetInput(input, description);
                        AbstractInfoView.this.fComputeProgressMonitor = null;
                    }
                });
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    protected String computeDescription(IWorkbenchPart part, ISelection selection, IJavaElement inputElement, IProgressMonitor localASTMonitor) {
        long flags = inputElement instanceof ILocalVariable ? this.LOCAL_VARIABLE_TITLE_FLAGS : (inputElement instanceof ITypeParameter ? this.TYPE_PARAMETER_TITLE_FLAGS : this.TITLE_FLAGS);
        return JavaElementLabels.getElementLabel(inputElement, flags);
    }

    private void doSetInput(Object input, String description) {
        this.doSetInput(input);
        this.fGotoInputAction.setEnabled(true);
        IJavaElement inputElement = this.getInput();
        this.setContentDescription(description);
        this.setTitleToolTip(JavaElementLabels.getElementLabel(inputElement, TOOLTIP_LABEL_FLAGS));
    }
}

