/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.jface;

import net.sf.colorer.FileType;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import net.sf.colorer.eclipse.jface.TextViewerExt5Stub;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.DeepLevelCounter;
import net.sf.colorer.editor.PairMatch;
import net.sf.colorer.handlers.LineRegion;
import net.sf.colorer.handlers.RegionDefine;
import net.sf.colorer.handlers.RegionMapper;
import net.sf.colorer.handlers.StyledRegion;
import net.sf.colorer.impl.Logger;
import net.sf.colorer.swt.ColorManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class TextColorer {
    static final int ASYNC_DELAY = 500;
    public static final int HLS_NONE = 0;
    public static final int HLS_XOR = 1;
    public static final int HLS_OUTLINE = 2;
    public static final int HLS_OUTLINE2 = 3;
    private int highlightStyle = 1;
    private boolean fullBackground = false;
    private boolean vertCross = false;
    private boolean horzCross = false;
    private RegionDefine vertCrossColor = null;
    private RegionDefine horzCrossColor = null;
    private PairMatch currentPair = null;
    int prevLine = 0;
    int visibleStart;
    int visibleEnd;
    long fModTimestamp;
    boolean lineHighlighting = true;
    boolean pairsHighlighting = true;
    private IDocument fDocument;
    private ColorManager fColorManager;
    private BaseEditor fBaseEditor;
    private IColorerEditorAdapter fEditor;
    private StyledText text;
    private ITextViewer fViewer;
    private ITextViewerExtension5 fProjectionViewer;
    private WidgetEventHandler fHandler = new WidgetEventHandler();
    private AsyncReconcyler fReconciler = new AsyncReconcyler();
    private DeepLevelCounter fDeepLevelCounter;
    private int fBackgroundScale = 0;

    private Color getDeepFGColor(DeepLevelCounter deepLevelCounter, int lno, StyledRegion rdef) {
        if (!rdef.bfore) {
            return null;
        }
        int r = rdef.fore >> 16;
        int g = (rdef.fore & 0xFF00) >> 8;
        int b = rdef.fore & 0xFF;
        if (deepLevelCounter != null && this.fBackgroundScale > 0) {
            int level = deepLevelCounter.getLineDeepLevel(lno);
            int maxlevel = deepLevelCounter.getMaxDeepLevel();
            r += (255 - r) * level / maxlevel * this.fBackgroundScale / 10 / 8;
            r = Math.max(0, Math.min(r, 255));
            g += (255 - g) * level / maxlevel * this.fBackgroundScale / 10 / 8;
            g = Math.max(0, Math.min(g, 255));
            b += (255 - b) * level / maxlevel * this.fBackgroundScale / 10 / 8;
            b = Math.max(0, Math.min(b, 255));
        }
        int newc = b + (g << 8) + (r << 16);
        return this.fColorManager.getColor(true, newc);
    }

    private Color getDeepBGColor(DeepLevelCounter deepLevelCounter, int lno, StyledRegion rdef) {
        if (!rdef.bback) {
            return null;
        }
        int r = rdef.back >> 16;
        int g = (rdef.back & 0xFF00) >> 8;
        int b = rdef.back & 0xFF;
        if (deepLevelCounter != null && this.fBackgroundScale > 0) {
            int level = deepLevelCounter.getLineDeepLevel(lno);
            int maxlevel = deepLevelCounter.getMaxDeepLevel();
            r -= r * level / maxlevel / 6 * this.fBackgroundScale / 5;
            r = Math.max(0, Math.min(r, 255));
            g -= g * level / maxlevel / 6 * this.fBackgroundScale / 5;
            g = Math.max(0, Math.min(g, 255));
            b -= b * level / maxlevel / 6 * this.fBackgroundScale / 5;
            b = Math.max(0, Math.min(b, 255));
        }
        int newbg = b + (g << 8) + (r << 16);
        return this.fColorManager.getColor(true, newbg);
    }

    Color getDeepBGColor(DeepLevelCounter deepLevelCounter, int lno, Color color) {
        if (deepLevelCounter != null && this.fBackgroundScale > 0) {
            int level = deepLevelCounter.getLineDeepLevel(lno);
            int maxlevel = deepLevelCounter.getMaxDeepLevel();
            if (level == 0) {
                return color;
            }
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            r -= r * level / maxlevel / 6 * this.fBackgroundScale / 5;
            r = Math.max(0, Math.min(r, 255));
            g -= g * level / maxlevel / 6 * this.fBackgroundScale / 5;
            g = Math.max(0, Math.min(g, 255));
            b -= b * level / maxlevel / 6 * this.fBackgroundScale / 5;
            b = Math.max(0, Math.min(b, 255));
            int newbg = b + (g << 8) + (r << 16);
            return this.fColorManager.getColor(true, newbg);
        }
        return color;
    }

    public TextColorer(IColorerEditorAdapter editor) {
        this.fEditor = editor;
    }

    void attach(StyledText parent) {
        this.text = parent;
        this.text.addDisposeListener((DisposeListener)this.fHandler);
        this.text.addLineBackgroundListener((LineBackgroundListener)this.fHandler);
        this.text.addPaintListener((PaintListener)this.fHandler);
        this.text.addControlListener((ControlListener)this.fHandler);
        this.text.addKeyListener((KeyListener)this.fHandler);
        this.text.addTraverseListener((TraverseListener)this.fHandler);
        this.text.addMouseListener((MouseListener)this.fHandler);
        this.fViewer.addViewportListener((IViewportListener)this.fHandler);
    }

    void detach() {
        if (this.text == null) {
            return;
        }
        this.text.removeDisposeListener((DisposeListener)this.fHandler);
        this.text.removeLineBackgroundListener((LineBackgroundListener)this.fHandler);
        this.text.removePaintListener((PaintListener)this.fHandler);
        this.text.removeControlListener((ControlListener)this.fHandler);
        this.text.removeKeyListener((KeyListener)this.fHandler);
        this.text.removeTraverseListener((TraverseListener)this.fHandler);
        this.text.removeMouseListener((MouseListener)this.fHandler);
        this.fViewer.removeViewportListener((IViewportListener)this.fHandler);
        this.text = null;
    }

    public void relink() {
        this.fBaseEditor = null;
        this.fReconciler.setDocument(this.fDocument);
        this.updateViewport();
        this.invalidateSyntax();
    }

    public void invalidateSyntax() {
        this.fBaseEditor.modifyEvent(0);
        this.fViewer.invalidateTextPresentation();
    }

    void checkActive() {
        if (this.text == null) {
            throw new RuntimeException("Object is not attached to StyledText");
        }
    }

    public FileType chooseFileType(String filename) {
        this.checkActive();
        FileType selected = this.fBaseEditor.chooseFileType(filename);
        this.invalidateSyntax();
        return selected;
    }

    public void setFileType(FileType typename) {
        this.checkActive();
        this.fBaseEditor.setFileType(typename);
        this.invalidateSyntax();
    }

    public FileType getFileType() {
        this.checkActive();
        return this.fBaseEditor.getFileType();
    }

    public void setRegionMapper(RegionMapper regionMapper, boolean useBackground) {
        this.fBaseEditor.setRegionMapper(regionMapper);
        StyledRegion sr = (StyledRegion)this.fBaseEditor.getBackground();
        this.text.setForeground(null);
        this.text.setBackground(null);
        if (useBackground) {
            this.text.setForeground(this.fColorManager.getColor(sr.bfore, sr.fore));
            this.text.setBackground(this.fColorManager.getColor(sr.bback, sr.back));
        }
        this.setCross(this.vertCross, this.horzCross);
        this.invalidateSyntax();
    }

    public void setRegionMapper(String hrdName, boolean useBackground) {
        this.fBaseEditor.setRegionMapper("rgb", hrdName);
        StyledRegion sr = (StyledRegion)this.fBaseEditor.getBackground();
        this.text.setForeground(null);
        this.text.setBackground(null);
        if (useBackground) {
            this.text.setForeground(this.fColorManager.getColor(sr.bfore, sr.fore));
            this.text.setBackground(this.fColorManager.getColor(sr.bback, sr.back));
        }
        this.setCross(this.vertCross, this.horzCross);
        this.invalidateSyntax();
    }

    public void setFullBackground(boolean full) {
        this.fullBackground = full;
        this.invalidateSyntax();
    }

    public void setCross(boolean horz, boolean vert) {
        this.horzCross = horz;
        this.vertCross = vert;
        this.vertCrossColor = null;
        this.horzCrossColor = null;
        if (this.horzCross) {
            this.horzCrossColor = this.fBaseEditor.getHorzCross();
        }
        if (this.vertCross) {
            this.vertCrossColor = this.fBaseEditor.getVertCross();
        }
        this.fViewer.invalidateTextPresentation();
    }

    public void setPairsPainter(int style) {
        this.highlightStyle = style;
        this.text.redraw();
    }

    public boolean pairAvailable() {
        return this.currentPair != null;
    }

    public boolean matchPair() {
        if (this.currentPair == null) {
            return false;
        }
        try {
            if (this.currentPair.end == null) {
                this.fBaseEditor.searchGlobalPair(this.currentPair);
            }
            if (this.currentPair.end == null) {
                return false;
            }
            int position = this.fDocument.getLineOffset(this.currentPair.eline);
            position = this.currentPair.topPosition ? (position += this.currentPair.end.end) : (position += this.currentPair.end.start);
            this.fEditor.selectAndReveal(position, 0);
            return true;
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false, (String)"Never reach");
            return false;
        }
    }

    public boolean selectPair() {
        if (this.currentPair == null) {
            return false;
        }
        try {
            if (this.currentPair.end == null) {
                this.fBaseEditor.searchGlobalPair(this.currentPair);
            }
            if (this.currentPair.end == null) {
                return false;
            }
            if (this.currentPair.topPosition) {
                int offset = this.fDocument.getLineOffset(this.currentPair.sline) + this.currentPair.start.start;
                this.fEditor.selectAndReveal(offset, this.fDocument.getLineOffset(this.currentPair.eline) + this.currentPair.end.end - offset);
            } else {
                int offset = this.fDocument.getLineOffset(this.currentPair.eline) + this.currentPair.end.start;
                this.fEditor.selectAndReveal(offset, this.fDocument.getLineOffset(this.currentPair.sline) + this.currentPair.start.end - offset);
            }
            return true;
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false, (String)"Never reach");
            return false;
        }
    }

    public boolean selectContentPair() {
        if (this.currentPair == null) {
            return false;
        }
        try {
            if (this.currentPair.end == null) {
                this.fBaseEditor.searchGlobalPair(this.currentPair);
            }
            if (this.currentPair.end == null) {
                return false;
            }
            if (this.currentPair.topPosition) {
                int offset = this.fDocument.getLineOffset(this.currentPair.sline) + this.currentPair.start.end;
                this.fEditor.selectAndReveal(offset, this.fDocument.getLineOffset(this.currentPair.eline) + this.currentPair.end.start - offset);
            } else {
                int offset = this.fDocument.getLineOffset(this.currentPair.eline) + this.currentPair.end.end;
                this.fEditor.selectAndReveal(offset, this.fDocument.getLineOffset(this.currentPair.sline) + this.currentPair.start.start - offset);
            }
            return true;
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false, (String)"Never reach");
            return false;
        }
    }

    public LineRegion getCaretRegion() {
        LineRegion caretRegion = null;
        try {
            int caret = this.fProjectionViewer.widgetOffset2ModelOffset(this.text.getCaretOffset());
            int lno = this.fDocument.getLineOfOffset(caret);
            int linepos = caret - this.fDocument.getLineOffset(lno);
            LineRegion[] arr = this.fBaseEditor.getLineRegions(lno);
            if (arr == null) {
                return null;
            }
            for (int idx = 0; idx < arr.length; ++idx) {
                if (arr[idx].start > linepos || arr[idx].end <= linepos || arr[idx].special) continue;
                caretRegion = arr[idx];
            }
            return caretRegion;
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false, (String)"Never reach");
            return null;
        }
    }

    boolean canProcess() {
        return System.currentTimeMillis() - this.fModTimestamp > 500L;
    }

    void stateChanged() {
        if (this.fDocument == null) {
            return;
        }
        this.updateViewport();
        this.fReconciler.repairPresentation(true);
        try {
            int curOffset = this.fProjectionViewer.widgetOffset2ModelOffset(this.text.getCaretOffset());
            int curLine = this.fDocument.getLineOfOffset(curOffset);
            if (this.lineHighlighting && this.text.getSelectionRange().y != 0) {
                this.lineHighlighting = false;
                this.drawLine(this.prevLine);
                this.pairsHighlighting = false;
                this.pairsDraw(null, this.currentPair);
                return;
            }
            if (this.text.getSelectionRange().y != 0) {
                return;
            }
            if (curLine < this.visibleStart || curLine > this.visibleEnd) {
                return;
            }
            if (!this.lineHighlighting) {
                this.lineHighlighting = true;
                this.drawLine(curLine);
            } else if (curLine != this.prevLine) {
                this.drawLine(this.prevLine);
                this.drawLine(curLine);
                this.prevLine = curLine;
            }
            if (!this.pairsHighlighting) {
                this.pairsHighlighting = true;
                this.pairsDraw(null, this.currentPair);
            } else {
                int lineOffset = this.fDocument.getLineOffset(curLine);
                PairMatch newmatch = this.fBaseEditor.getPairMatch(curLine, curOffset - lineOffset);
                if (newmatch != null) {
                    this.fBaseEditor.searchLocalPair(newmatch);
                }
                if (newmatch == null && this.currentPair != null || newmatch != null && !newmatch.equals(this.currentPair)) {
                    this.pairsDraw(null, this.currentPair);
                    this.pairsDraw(null, newmatch);
                }
                this.currentPair = newmatch;
            }
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false, (String)"Never reach");
        }
    }

    void updateViewport() {
        this.checkActive();
        if (this.fDocument == null) {
            return;
        }
        this.visibleStart = 0;
        try {
            this.visibleStart = this.fViewer.getTopIndex() - 1;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.visibleStart < 0) {
            this.visibleStart = 0;
        }
        this.visibleEnd = this.fViewer.getBottomIndex();
        int lc = this.fDocument.getNumberOfLines();
        if (this.visibleEnd > lc) {
            this.visibleEnd = lc;
        }
        if (this.visibleEnd <= this.visibleStart) {
            this.visibleEnd = this.visibleStart + 1;
        }
        this.fBaseEditor.visibleTextEvent(this.visibleStart, this.visibleEnd - this.visibleStart + 1);
    }

    void pairDraw(GC gc, StyledRegion sr, int start, int end) {
        if (start > this.text.getCharCount() || end > this.text.getCharCount()) {
            return;
        }
        if (gc != null) {
            Point left = this.text.getLocationAtOffset(start);
            Point right = this.text.getLocationAtOffset(end);
            if (sr != null) {
                if (this.highlightStyle == 1) {
                    int resultColor = sr.fore ^ this.fColorManager.getColor(this.text.getBackground());
                    if (this.text.getLineAtOffset(this.text.getCaretOffset()) == this.text.getLineAtOffset(start) && this.horzCross && this.horzCrossColor != null && ((StyledRegion)this.horzCrossColor).bback) {
                        resultColor = sr.fore ^ ((StyledRegion)this.horzCrossColor).back;
                    }
                    Color color = this.fColorManager.getColor(sr.bfore, resultColor);
                    gc.setBackground(color);
                    gc.setXORMode(true);
                    gc.fillRectangle(left.x, left.y, right.x - left.x, gc.getFontMetrics().getHeight());
                } else if (this.highlightStyle == 2) {
                    Color color = this.fColorManager.getColor(sr.bfore, sr.fore);
                    gc.setForeground(color);
                    gc.drawRectangle(left.x, left.y, right.x - left.x - 1, gc.getFontMetrics().getHeight() - 1);
                } else if (this.highlightStyle == 3) {
                    Color color = this.fColorManager.getColor(sr.bfore, sr.fore);
                    gc.setForeground(color);
                    gc.setLineWidth(2);
                    gc.drawRectangle(left.x + 1, left.y + 1, right.x - left.x - 2, gc.getFontMetrics().getHeight() - 2);
                }
            }
        } else {
            this.text.redrawRange(start, end - start, true);
        }
    }

    void pairsDraw(GC gc, PairMatch pm) {
        if (pm == null) {
            return;
        }
        try {
            int drawStart;
            int lineOffset;
            if (pm.start != null) {
                if (pm.sline < this.visibleStart || pm.sline > this.visibleEnd) {
                    return;
                }
                lineOffset = this.fDocument.getLineOffset(pm.sline);
                drawStart = this.fProjectionViewer.modelOffset2WidgetOffset(lineOffset);
                if (drawStart == -1) {
                    return;
                }
                this.pairDraw(gc, (StyledRegion)pm.start.rdef, pm.start.start + drawStart, pm.start.end + drawStart);
            }
            if (pm.end != null) {
                if (pm.eline < this.visibleStart || pm.eline > this.visibleEnd) {
                    return;
                }
                lineOffset = this.fDocument.getLineOffset(pm.eline);
                drawStart = this.fProjectionViewer.modelOffset2WidgetOffset(lineOffset);
                if (drawStart == -1) {
                    return;
                }
                this.pairDraw(gc, (StyledRegion)pm.end.rdef, pm.end.start + drawStart, pm.end.end + drawStart);
            }
        }
        catch (BadLocationException e) {
            Assert.isTrue((boolean)false, (String)"Never reach");
        }
    }

    void drawLine(int lno) {
        if (lno < 0 || lno >= this.fDocument.getNumberOfLines()) {
            return;
        }
        int widgetLine = this.fProjectionViewer.modelLine2WidgetLine(lno);
        if (widgetLine == -1) {
            return;
        }
        int y = this.text.getLocationAtOffset((int)this.text.getOffsetAtLine((int)widgetLine)).y;
        int height = 0;
        height = this.text.getLineCount() > widgetLine + 1 ? this.text.getLocationAtOffset((int)this.text.getOffsetAtLine((int)(widgetLine + 1))).y - y : this.text.getLocationAtOffset((int)this.text.getCharCount()).y + this.text.getLineHeight();
        int width = this.text.getClientArea().width + this.text.getHorizontalPixel();
        this.text.redraw(0, y, width, height, false);
    }

    public IPresentationReconciler getPresentationReconciler() {
        return this.fReconciler;
    }

    public void setBackgroundScale(int back_scale) {
        this.fBackgroundScale = back_scale;
        if (this.fBackgroundScale == 0) {
            if (this.fDeepLevelCounter != null) {
                this.fDeepLevelCounter.uninstall();
                this.fDeepLevelCounter = null;
            }
        } else if (this.fDeepLevelCounter == null) {
            this.fDeepLevelCounter = new DeepLevelCounter();
            this.fDeepLevelCounter.install(this.fBaseEditor);
        }
    }

    class WidgetEventHandler
    implements KeyListener,
    DisposeListener,
    LineBackgroundListener,
    PaintListener,
    TraverseListener,
    ControlListener,
    MouseListener,
    ISelectionChangedListener,
    IViewportListener {
        WidgetEventHandler() {
        }

        public void widgetDisposed(DisposeEvent e) {
            TextColorer.this.detach();
        }

        public void lineGetBackground(LineBackgroundEvent e) {
            int lno = TextColorer.this.text.getLineAtOffset(e.lineOffset);
            int caret = TextColorer.this.text.getCaretOffset();
            int length = e.lineText.length();
            if (TextColorer.this.horzCrossColor != null && TextColorer.this.horzCross && TextColorer.this.lineHighlighting && e.lineOffset <= caret && caret <= e.lineOffset + length) {
                e.lineBackground = TextColorer.this.fColorManager.getColor(((StyledRegion)((TextColorer)TextColorer.this).horzCrossColor).bback, ((StyledRegion)((TextColorer)TextColorer.this).horzCrossColor).back);
                return;
            }
            if (!TextColorer.this.fullBackground) {
                return;
            }
            LineRegion[] lr = TextColorer.this.fBaseEditor.getLineRegions(TextColorer.this.fProjectionViewer.widgetLine2ModelLine(lno));
            for (int idx = 0; idx < lr.length; ++idx) {
                StyledRegion rdef = (StyledRegion)lr[idx].rdef;
                if (lr[idx].end != -1 || rdef == null) continue;
                e.lineBackground = TextColorer.this.fColorManager.getColor(rdef.bback, rdef.back);
            }
            e.lineBackground = TextColorer.this.getDeepBGColor(TextColorer.this.fDeepLevelCounter, TextColorer.this.fProjectionViewer.widgetLine2ModelLine(lno), e.lineBackground == null ? TextColorer.this.text.getBackground() : e.lineBackground);
        }

        public void paintControl(PaintEvent e) {
            if (!TextColorer.this.pairsHighlighting) {
                return;
            }
            TextColorer.this.pairsDraw(e.gc, TextColorer.this.currentPair);
        }

        public void keyPressed(KeyEvent e) {
            TextColorer.this.stateChanged();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTraversed(TraverseEvent e) {
            TextColorer.this.stateChanged();
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            TextColorer.this.stateChanged();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            TextColorer.this.stateChanged();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TextColorer.this.stateChanged();
        }

        public void viewportChanged(int verticalOffset) {
            TextColorer.this.stateChanged();
        }
    }

    class AsyncReconcyler
    implements IPresentationReconciler,
    ITextListener,
    ITextInputListener,
    Runnable {
        static final int MAX_SINGLE_PARSE_SIZE = 30000;
        static final int INCREMENTAL_PARSE_SIZE = 5000;
        private IRegion fDamage;
        private Display fDisplay;

        AsyncReconcyler() {
        }

        public void install(ITextViewer viewer) {
            TextColorer.this.fViewer = viewer;
            if (TextColorer.this.fViewer instanceof ITextViewerExtension5) {
                TextColorer.this.fProjectionViewer = (ITextViewerExtension5)((ProjectionViewer)TextColorer.this.fViewer);
            } else {
                TextColorer.this.fProjectionViewer = new TextViewerExt5Stub();
            }
            TextColorer.this.fViewer.addTextListener((ITextListener)this);
            TextColorer.this.fViewer.addTextInputListener((ITextInputListener)this);
            this.fDisplay = Display.getCurrent();
            new Thread(this).start();
            TextColorer.this.attach(TextColorer.this.fViewer.getTextWidget());
        }

        public void uninstall() {
            if (TextColorer.this.fViewer != null) {
                TextColorer.this.fViewer.removeTextListener((ITextListener)this);
                TextColorer.this.fViewer.removeTextInputListener((ITextInputListener)this);
            }
            TextColorer.this.detach();
            TextColorer.this.fViewer = null;
        }

        void setDocument(IDocument document) {
            TextColorer.this.fDocument = document;
            TextColorer.this.fDeepLevelCounter = null;
            if (TextColorer.this.fDocument == null) {
                return;
            }
            TextColorer.this.fColorManager = TextColorer.this.fEditor.getColorManager();
            TextColorer.this.fBaseEditor = TextColorer.this.fEditor.getBaseEditor();
            TextColorer.this.fBaseEditor.setRegionCompact(true);
            TextColorer.this.fBaseEditor.lineCountEvent(TextColorer.this.fDocument.getNumberOfLines());
            this.fDamage = new Region(0, TextColorer.this.fDocument.getLength());
        }

        IRegion getDamageRegion(DocumentEvent event) {
            if (event == null) {
                return null;
            }
            try {
                TextColorer.this.fBaseEditor.modifyEvent(TextColorer.this.fDocument.getLineOfOffset(event.getOffset()));
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            TextColorer.this.fBaseEditor.lineCountEvent(TextColorer.this.fDocument.getNumberOfLines());
            try {
                int soffset = TextColorer.this.fDocument.getLineInformationOfOffset(event.getOffset()).getOffset();
                if (this.fDamage != null && soffset > this.fDamage.getOffset()) {
                    soffset = this.fDamage.getOffset();
                }
                return new Region(soffset, TextColorer.this.fDocument.getLength() - soffset);
            }
            catch (BadLocationException e) {
                Logger.error("CDR", "getDamageRegion", e);
                return null;
            }
        }

        IRegion getVisualDamageRegion(TextEvent event) {
            try {
                int sOffset = TextColorer.this.fProjectionViewer.widgetOffset2ModelOffset(event.getOffset());
                if (sOffset == -1) {
                    sOffset = 0;
                }
                sOffset = TextColorer.this.fDocument.getLineInformationOfOffset(sOffset).getOffset();
                int eOffset = TextColorer.this.fProjectionViewer.widgetOffset2ModelOffset(event.getOffset() + event.getLength());
                if (eOffset == -1) {
                    eOffset = TextColorer.this.fDocument.getLength();
                }
                IRegion eOffsetLine = TextColorer.this.fDocument.getLineInformationOfOffset(eOffset);
                eOffset = eOffsetLine.getOffset() + eOffsetLine.getLength();
                if (event.getOffset() == 0 && event.getLength() == 0 && event.getText() == null) {
                    sOffset = 0;
                    eOffset = TextColorer.this.fDocument.getLength();
                }
                if (this.fDamage != null && sOffset > this.fDamage.getOffset()) {
                    sOffset = this.fDamage.getOffset();
                }
                return new Region(sOffset, eOffset - sOffset);
            }
            catch (BadLocationException e) {
                Logger.error("CDR", "getVisualDamageRegion", e);
                return null;
            }
        }

        public void textChanged(TextEvent event) {
            if (TextColorer.this.fDocument == null) {
                return;
            }
            TextColorer.this.updateViewport();
            IRegion newDamage = null;
            if (event.getDocumentEvent() != null) {
                newDamage = this.getDamageRegion(event.getDocumentEvent());
                if (newDamage != null) {
                    this.fDamage = newDamage;
                }
                this.repairPresentation(true);
                TextColorer.this.fModTimestamp = System.currentTimeMillis();
            } else {
                newDamage = this.getVisualDamageRegion(event);
                if (newDamage != null) {
                    this.fDamage = newDamage;
                }
                this.repairPresentation(false);
            }
        }

        void createPresentation(TextPresentation presentation, IRegion damage) {
            try {
                int l_start = TextColorer.this.fDocument.getLineOfOffset(damage.getOffset());
                int l_end = TextColorer.this.fDocument.getLineOfOffset(damage.getOffset() + damage.getLength());
                int fLastPos = -1;
                for (int lno = l_start; lno <= l_end; ++lno) {
                    LineRegion[] lrarr = TextColorer.this.fBaseEditor.getLineRegions(lno);
                    for (int idx = 0; idx < lrarr.length; ++idx) {
                        LineRegion lr = lrarr[idx];
                        StyledRegion rdef = (StyledRegion)lr.rdef;
                        if (rdef == null || lr.special) continue;
                        IRegion lineinfo = TextColorer.this.fDocument.getLineInformation(lno);
                        int start = lr.start;
                        int end = lr.end;
                        if (end == -1) {
                            end = lineinfo.getLength();
                        }
                        int length = end - start;
                        start = lineinfo.getOffset() + start;
                        if (length == 0) continue;
                        Logger.trace("CDR", "trace line:" + lno + "lineofset=" + lineinfo.getOffset() + "linelength=" + lineinfo.getLength() + " start=" + start + " length=" + length);
                        if (fLastPos > start) {
                            Logger.error("CDR", "sequence failure");
                        }
                        fLastPos = start + length;
                        StyleRange sr = new StyleRange(start, length, TextColorer.this.getDeepFGColor(TextColorer.this.fDeepLevelCounter, lno, rdef), TextColorer.this.getDeepBGColor(TextColorer.this.fDeepLevelCounter, lno, rdef), rdef.style);
                        presentation.addStyleRange(sr);
                    }
                }
                Logger.trace("CDR", "createPresentation: filled");
            }
            catch (BadLocationException e) {
                Logger.error("CDR", "StyleRange fill error", e);
            }
        }

        public void run() {
            while (TextColorer.this.fViewer != null && !this.fDisplay.isDisposed()) {
                this.fDisplay.asyncExec(new Runnable(){

                    public void run() {
                        if (System.currentTimeMillis() > ((AsyncReconcyler)AsyncReconcyler.this).TextColorer.this.fModTimestamp + 500L - 200L) {
                            AsyncReconcyler.this.repairPresentation(false);
                        }
                    }
                });
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }

        public void repairPresentation(boolean visual) {
            if (this.fDamage == null || TextColorer.this.fViewer == null) {
                return;
            }
            try {
                int newlen = TextColorer.this.fViewer.getBottomIndexEndOffset() - this.fDamage.getOffset();
                if (visual && newlen <= 0) {
                    return;
                }
                if (newlen <= 0) {
                    newlen = 5000;
                }
                if (newlen > this.fDamage.getLength()) {
                    newlen = this.fDamage.getLength();
                }
                newlen = Math.min(newlen, 30000);
                IRegion endline = TextColorer.this.fDocument.getLineInformationOfOffset(this.fDamage.getOffset() + newlen);
                newlen = endline.getOffset() + endline.getLength() - this.fDamage.getOffset();
                Region visibleDamage = new Region(this.fDamage.getOffset(), newlen);
                if (visibleDamage.getLength() == 0) {
                    return;
                }
                TextPresentation presentation = new TextPresentation((IRegion)visibleDamage, 10 + newlen / 10);
                this.createPresentation(presentation, (IRegion)visibleDamage);
                int widgetOffset = TextColorer.this.fProjectionViewer.modelOffset2WidgetOffset(visibleDamage.getOffset());
                int widgetLength = TextColorer.this.fProjectionViewer.modelOffset2WidgetOffset(visibleDamage.getOffset() + visibleDamage.getLength()) - widgetOffset;
                try {
                    if (widgetOffset >= 0 && widgetLength > 0) {
                        TextColorer.this.text.setStyleRanges(widgetOffset, widgetLength, null, null);
                    }
                }
                catch (Throwable e) {
                    Logger.error("CDR", "setStyleRanges: ", e);
                }
                int newstart = visibleDamage.getOffset() + visibleDamage.getLength();
                this.fDamage = new Region(newstart, this.fDamage.getOffset() + this.fDamage.getLength() - newstart);
                if (this.fDamage.getLength() <= 0) {
                    this.fDamage = null;
                }
                TextColorer.this.fViewer.changeTextPresentation(presentation, false);
            }
            catch (Exception e) {
                Logger.error("CDR", "runnable repairer failed", e);
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput != null) {
                this.setDocument(newInput);
                TextColorer.this.fEditor.handleAttachComplete();
            }
        }

        public IPresentationDamager getDamager(String contentType) {
            return null;
        }

        public IPresentationRepairer getRepairer(String contentType) {
            return null;
        }
    }
}

