/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.Version;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;

public class JhlClientAdapterFactory
extends SVNClientAdapterFactory {
    private static boolean availabilityCached = false;
    private static boolean available;
    private static StringBuffer javaHLErrors;
    public static final String JAVAHL_CLIENT = "javahl";

    static {
        javaHLErrors = new StringBuffer("Failed to load JavaHL Library.\nThese are the errors that were encountered:\n");
    }

    private JhlClientAdapterFactory() {
    }

    protected ISVNClientAdapter createSVNClientImpl() {
        return new JhlClientAdapter();
    }

    protected String getClientType() {
        return JAVAHL_CLIENT;
    }

    public static void setup() throws SVNClientException {
        if (!JhlClientAdapterFactory.isAvailable()) {
            throw new SVNClientException("Javahl client adapter is not available");
        }
        SVNClientAdapterFactory.registerAdapterFactory((SVNClientAdapterFactory)new JhlClientAdapterFactory());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailable() {
        block66: {
            if (availabilityCached) return available;
            Class<?> c = null;
            try {
                c = Class.forName("org.tigris.subversion.javahl.ClientException");
                if (c == null) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                availabilityCached = true;
                return false;
            }
            if (JhlClientAdapterFactory.isOsWindows()) {
                try {
                    System.loadLibrary("libapr-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libapriconv-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libeay32");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("ssleay32");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libaprutil-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("dbghelp");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsasl");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_subr-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_delta-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_diff-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_wc-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_fs-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_repos-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_ra-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                try {
                    System.loadLibrary("libsvn_client-1");
                }
                catch (Exception e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
            }
            available = false;
            try {
                try {
                    try {
                        String specifiedLibraryName = System.getProperty("subversion.native.library");
                        if (specifiedLibraryName != null) {
                            System.load(specifiedLibraryName);
                            available = true;
                        }
                    }
                    catch (UnsatisfiedLinkError ex) {
                        javaHLErrors.append(ex.getMessage()).append("\n");
                    }
                    if (!available) {
                        try {
                            System.loadLibrary("libsvnjavahl-1");
                        }
                        catch (UnsatisfiedLinkError ex) {
                            javaHLErrors.append(String.valueOf(ex.getMessage()) + "\n");
                            try {
                                System.loadLibrary("svnjavahl-1");
                            }
                            catch (UnsatisfiedLinkError e) {
                                javaHLErrors.append(e.getMessage()).append("\n");
                                System.loadLibrary("svnjavahl");
                            }
                        }
                        available = true;
                    }
                }
                catch (Exception e) {
                    available = false;
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    available = false;
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
            }
            catch (Throwable throwable) {
                Object var3_39 = null;
                availabilityCached = true;
                throw throwable;
            }
            {
                Object var3_40 = null;
                availabilityCached = true;
                if (available) break block66;
            }
            String libraryPath = System.getProperty("java.library.path");
            if (libraryPath == null) return available;
            javaHLErrors.append("java.library.path = " + libraryPath);
            return available;
        }
        try {
            SVNClient svnClient = new SVNClient();
            Version version = svnClient.getVersion();
            if (version.getMajor() == 1 && version.getMinor() == 6) {
                available = true;
                return available;
            }
            available = false;
            javaHLErrors = new StringBuffer("Incompatible JavaHL library loaded.  1.6.x or later required.");
            return available;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            available = false;
            javaHLErrors = new StringBuffer("Incompatible JavaHL library loaded.  1.6.x or later required.");
        }
        return available;
    }

    public static boolean isOsWindows() {
        try {
            return System.getProperty("os.name").startsWith("Windows");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String getLibraryLoadErrors() {
        if (JhlClientAdapterFactory.isAvailable()) {
            return "";
        }
        return javaHLErrors.toString();
    }
}

