/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.builders;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.epic.core.builders.PerlBuilderJob;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlBuilder
extends IncrementalProjectBuilder {
    private Set dirtyResources;
    private Set newDirtyResources;
    private Set validatedResources;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        try {
            this.dirtyResources = new HashSet();
            this.newDirtyResources = new HashSet();
            this.validatedResources = new HashSet();
            IProject[] iProjectArray = this.buildImpl(kind, args, monitor);
            return iProjectArray;
        }
        finally {
            this.dirtyResources = null;
            this.newDirtyResources = null;
            this.validatedResources = null;
        }
    }

    private IProject[] buildImpl(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (PerlEditorPlugin.getDefault().requirePerlInterpreter(false)) {
            this.cancelPreviousPerlBuilderJob();
            this.findDirtyResources(kind);
            this.startPerlBuilderJob();
        }
        return null;
    }

    private void visitResource(IResource resource) {
        switch (resource.getType()) {
            case 4: {
                this.validatedResources.add(resource);
                break;
            }
            case 1: {
                this.validatedResources.remove(resource);
                this.dirtyResources.add(resource);
                this.newDirtyResources.add(resource);
            }
        }
    }

    private void cancelPreviousPerlBuilderJob() {
        IJobManager jobMan = Platform.getJobManager();
        Job[] jobs = jobMan.find((Object)"PerlBuilder.jobFamily");
        if (jobs.length == 0) {
            return;
        }
        jobMan.cancel((Object)"PerlBuilder.jobFamily");
        try {
            jobMan.join((Object)"PerlBuilder.jobFamily", null);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        PerlBuilderJob cancelled = (PerlBuilderJob)jobs[0];
        this.dirtyResources.addAll(cancelled.getDirtyResources());
    }

    private void findDirtyResources(int buildKind) {
        try {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (buildKind == 6 || delta == null) {
                this.getProject().accept((IResourceVisitor)new BuildFullVisitor());
            } else {
                delta.accept((IResourceDeltaVisitor)new BuildDeltaVisitor());
            }
        }
        catch (CoreException e) {
            PerlEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Unexpected exception while building project " + this.getProject().getName() + "; report it as bug in plug-in " + PerlEditorPlugin.getPluginId(), (Throwable)e));
        }
    }

    private List getSortedDirtyResources() {
        ArrayList sorted = new ArrayList(this.dirtyResources.size());
        sorted.addAll(this.newDirtyResources);
        this.dirtyResources.removeAll(this.newDirtyResources);
        sorted.addAll(this.dirtyResources);
        return sorted;
    }

    private void startPerlBuilderJob() {
        PerlBuilderJob job = new PerlBuilderJob(this.getSortedDirtyResources(), this.validatedResources);
        job.setPriority(50);
        job.schedule();
    }

    private class BuildDeltaVisitor
    implements IResourceDeltaVisitor {
        private BuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getKind() == 4) {
                PerlBuilder.this.visitResource(delta.getResource());
            }
            return true;
        }
    }

    private class BuildFullVisitor
    implements IResourceVisitor {
        private BuildFullVisitor() {
        }

        public boolean visit(IResource resource) {
            PerlBuilder.this.visitResource(resource);
            return true;
        }
    }
}

