/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.epic.core.model.Package;
import org.epic.core.model.SourceFile;
import org.epic.perleditor.actions.AbstractOpenDeclaration;
import org.epic.perleditor.actions.OpenDeclarationAction;
import org.epic.perleditor.editors.PartitionTypes;

class OpenPackageDeclaration
extends AbstractOpenDeclaration {
    public OpenPackageDeclaration(OpenDeclarationAction action) {
        super(action);
    }

    @Override
    protected IRegion findDeclaration(SourceFile sourceFile, String moduleName) {
        for (Package pkg : sourceFile.getPackages()) {
            if (!pkg.getName().equals(moduleName)) continue;
            return new Region(pkg.getOffset(), pkg.getLength());
        }
        return null;
    }

    @Override
    protected String getLocalSearchString(String searchString) {
        return searchString;
    }

    @Override
    protected String getSearchString(ITextSelection selection) {
        return this.getSelectedModuleName(selection);
    }

    @Override
    protected String getTargetModule(String moduleName) {
        return moduleName;
    }

    private String getSelectedModuleName(ITextSelection selection) {
        ITypedRegion partition;
        IDocument doc;
        block3: {
            doc = this.getSourceDocument();
            try {
                partition = PartitionTypes.getPerlPartition(doc, selection.getOffset());
                if (partition.getType().equals("__dftl_partition_content_type")) break block3;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        String moduleName = doc.get(partition.getOffset(), partition.getLength());
        return moduleName;
    }
}

