/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedRegion;
import org.epic.core.parser.CurlyToken;
import org.epic.core.parser.OperatorToken;
import org.epic.core.parser.PerlMultiLexer;
import org.epic.core.parser.PerlToken;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.editors.TokensList;

public class PerlPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2,
IDocumentPartitionerExtension3 {
    private final Object TOKENS_LOCK = new Object();
    private final PerlMultiLexer lexer = new PerlMultiLexer();
    private final ILog log;
    private IDocument doc;
    private DocumentRewriteSession activeRewriteSession;
    private boolean initialized;
    private TokensList tokens;
    private int lastUnaffectedTokenI = -1;
    private int syncTokenI = -1;

    public PerlPartitioner(ILog log) {
        this.log = log;
        this.tokens = new TokensList();
    }

    public PerlPartitioner(ILog log, IDocument doc) {
        this(log);
        ((IDocumentExtension3)doc).setDocumentPartitioner("org.epic.perleditor.perlPartitioning", (IDocumentPartitioner)this);
        this.connect(doc);
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computePartitioning(offset, length, false);
    }

    public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        ArrayList<TypedRegion> typedRegions = new ArrayList<TypedRegion>();
        if (!this.initialized) {
            this.initialize();
        }
        if (this.tokens.isEmpty()) {
            return new ITypedRegion[]{new TypedRegion(0, this.doc.getLength(), "__dftl_partition_content_type")};
        }
        int tokenCount = this.tokens.size();
        int prevRegionEnd = -1;
        int i = Math.max(this.tokens.getTokenIndexPreceding(offset), 0);
        while (i < tokenCount) {
            int rLength;
            int rOffset;
            PerlToken t = (PerlToken)((Object)this.tokens.get(i));
            if (t.getOffset() >= offset + length) break;
            if (prevRegionEnd == -1) {
                if (t.includes(offset)) {
                    rOffset = offset;
                    rLength = t.getOffset() + t.getLength() - rOffset;
                    typedRegions.add(new TypedRegion(rOffset, rLength, this.getTokenContentType(t, i)));
                    if (includeZeroLengthPartitions) {
                        typedRegions.add(new TypedRegion(rOffset + rLength, 0, "__dftl_partition_content_type"));
                    }
                } else {
                    rOffset = offset;
                    rLength = 0;
                }
            } else {
                if (t.getOffset() - prevRegionEnd > 0) {
                    rOffset = prevRegionEnd;
                    rLength = t.getOffset() - rOffset;
                    typedRegions.add(new TypedRegion(rOffset, rLength, "__dftl_partition_content_type"));
                }
                rOffset = t.getOffset();
                rLength = Math.min(t.getLength(), offset + length - rOffset);
                typedRegions.add(new TypedRegion(rOffset, rLength, this.getTokenContentType(t, i)));
                if (includeZeroLengthPartitions) {
                    typedRegions.add(new TypedRegion(rOffset + rLength, 0, "__dftl_partition_content_type"));
                }
            }
            prevRegionEnd = rOffset + rLength;
            ++i;
        }
        if (prevRegionEnd < offset + length) {
            typedRegions.add(new TypedRegion(prevRegionEnd, offset + length - prevRegionEnd, "__dftl_partition_content_type"));
        }
        ITypedRegion[] ret = typedRegions.toArray(new ITypedRegion[typedRegions.size()]);
        return ret;
    }

    public void connect(IDocument document) {
        this.connect(document, false);
    }

    public void connect(IDocument document, boolean delayInitialization) {
        this.doc = document;
        this.initialized = false;
        if (!delayInitialization) {
            this.initialize();
        }
    }

    public void disconnect() {
        this.doc = null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.computeLastUnaffectedTokenI(event);
        this.computeSyncTokenI(event);
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion documentChanged2(DocumentEvent event) {
        try {
            Object object = this.TOKENS_LOCK;
            synchronized (object) {
                IRegion ret;
                IRegion iRegion = ret = this.documentChanged2Impl(event);
                return iRegion;
            }
        }
        finally {
            this.lastUnaffectedTokenI = -1;
            this.syncTokenI = -1;
        }
    }

    public DocumentRewriteSession getActiveRewriteSession() {
        return this.activeRewriteSession;
    }

    public String getContentType(int offset) {
        return this.getContentType(offset, false);
    }

    public String getContentType(int offset, boolean preferOpenPartitions) {
        return this.getPartition(offset, preferOpenPartitions).getType();
    }

    public String[] getLegalContentTypes() {
        return PartitionTypes.getTypes();
    }

    public String[] getManagingPositionCategories() {
        return null;
    }

    public ITypedRegion getPartition(int offset) {
        return this.getPartition(offset, false);
    }

    public ITypedRegion getPartition(int offset, boolean preferOpenPartitions) {
        ITypedRegion ret = this.getPartitionImpl(offset, preferOpenPartitions);
        assert (ret.getOffset() + ret.getLength() <= this.doc.getLength()) : "assertion failed: getPartition returned invalid result for offset " + offset + ": " + ret.getOffset() + ":" + ret.getLength() + ":" + ret.getType();
        return ret;
    }

    public List getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public Object getTokensLock() {
        return this.TOKENS_LOCK;
    }

    public void startRewriteSession(DocumentRewriteSession session) throws IllegalStateException {
        if (this.activeRewriteSession != null) {
            throw new IllegalStateException("another rewrite session is already active");
        }
        this.activeRewriteSession = session;
    }

    public void stopRewriteSession(DocumentRewriteSession session) {
        this.activeRewriteSession = null;
        this.initialize();
    }

    private void computeLastUnaffectedTokenI(DocumentEvent event) {
        try {
            PerlToken t;
            this.lastUnaffectedTokenI = this.tokens.getTokenIndexPreceding(event.getOffset());
            if (this.lastUnaffectedTokenI >= 0) {
                t = (PerlToken)((Object)this.tokens.get(this.lastUnaffectedTokenI));
                if (t.includes(event.getOffset())) {
                    --this.lastUnaffectedTokenI;
                }
            } else {
                this.lastUnaffectedTokenI = -1;
            }
            while (this.lastUnaffectedTokenI >= 0) {
                PerlToken prevT;
                t = (PerlToken)((Object)this.tokens.get(this.lastUnaffectedTokenI));
                PerlToken perlToken = prevT = this.lastUnaffectedTokenI > 0 ? (PerlToken)((Object)this.tokens.get(this.lastUnaffectedTokenI - 1)) : null;
                if (t.getType() == 14) {
                    if (prevT == null) break;
                    if (prevT.getType() != 55) {
                        break;
                    }
                }
                --this.lastUnaffectedTokenI;
            }
        }
        finally {
            assert (this.lastUnaffectedTokenI == -1 || this.tokens.get(this.lastUnaffectedTokenI) instanceof CurlyToken);
        }
    }

    private void computeSyncTokenI(DocumentEvent event) {
        int offset = event.getOffset() + event.getLength();
        this.syncTokenI = this.tokens.getTokenIndexPreceding(offset);
        if (this.syncTokenI < 0) {
            this.syncTokenI = -1;
        } else {
            ++this.syncTokenI;
            if (this.syncTokenI >= this.tokens.size()) {
                this.syncTokenI = -1;
            }
        }
    }

    private IRegion documentChanged2Impl(DocumentEvent event) {
        int parseStartOffset;
        CurlyToken parseStartCurly;
        PerlToken sync;
        assert (event.getDocument() == this.doc);
        String repl = event.getText();
        if (repl == null) {
            repl = "";
        }
        int shiftDelta = repl.length() - event.getLength();
        if (this.syncTokenI >= 0 && this.syncTokenI < this.tokens.size()) {
            sync = (PerlToken)((Object)this.tokens.get(this.syncTokenI));
            sync.shift(shiftDelta, 0);
            this.tokens.markSync(this.syncTokenI + 1);
        } else {
            sync = null;
        }
        if (this.lastUnaffectedTokenI >= 0) {
            parseStartCurly = (CurlyToken)((Object)this.tokens.get(this.lastUnaffectedTokenI));
            parseStartOffset = parseStartCurly.getOffset();
            this.tokens.truncate(this.lastUnaffectedTokenI);
        } else {
            parseStartOffset = 0;
            parseStartCurly = null;
            this.tokens.truncate(0);
        }
        this.lexer.reset(null, this.doc, parseStartCurly);
        try {
            PerlToken t;
            while ((t = this.nextToken(this.lexer)).getType() != 1) {
                if (t.equals((Object)sync)) {
                    int lineShiftDelta = t.getLine() - sync.getLine();
                    this.tokens.add(t);
                    int start = this.tokens.size();
                    this.tokens.addSync();
                    int pc = this.lexer.getCurlyLevel();
                    int tokenCount = this.tokens.size();
                    int i = start;
                    while (i < tokenCount) {
                        PerlToken pt = (PerlToken)((Object)this.tokens.get(i));
                        pt.shift(shiftDelta, lineShiftDelta);
                        if (pt instanceof CurlyToken) {
                            if (pt.getType() == 14) {
                                ((CurlyToken)pt).setLevel(pc);
                                ++pc;
                            } else {
                                ((CurlyToken)pt).setLevel(--pc);
                            }
                        }
                        ++i;
                    }
                    assert (this.tokens.noOverlaps());
                    return new Region(parseStartOffset, sync.getOffset() - parseStartOffset);
                }
                this.tokens.add(t);
            }
        }
        catch (TokenStreamException e) {
            if (e.getMessage().indexOf("unrecognized character at document offset") != -1) {
                this.log.log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Could not parse source file due to an unrecognized character. Check if the text file encoding is set correctly in Preferences/Editors.", (Throwable)e));
            }
            this.log.log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Could not parse source file. Report this exception as a bug, including the text fragment which triggers it, if possible.", (Throwable)e));
        }
        this.initialized = true;
        return new Region(parseStartOffset, this.doc.getLength() - parseStartOffset);
    }

    private ITypedRegion getPartitionImpl(int offset, boolean preferOpenPartitions) {
        if (!this.initialized) {
            this.initialize();
        }
        if (offset == this.doc.getLength()) {
            return new TypedRegion(offset, 0, "__dftl_partition_content_type");
        }
        int i = this.tokens.getTokenIndexPreceding(offset);
        if (i == -1) {
            if (!this.tokens.isEmpty()) {
                return new TypedRegion(0, ((PerlToken)((Object)this.tokens.get(0))).getOffset(), "__dftl_partition_content_type");
            }
            return new TypedRegion(0, 0, "__dftl_partition_content_type");
        }
        PerlToken t = (PerlToken)((Object)this.tokens.get(i));
        if (t.includes(offset)) {
            if (preferOpenPartitions && t.getOffset() == offset) {
                return new TypedRegion(offset, 0, "__dftl_partition_content_type");
            }
            if (i > 0 && t.getOffset() == offset && t.getType() == 24) {
                PerlToken t2 = (PerlToken)((Object)this.tokens.get(i - 1));
                if (t2.getOffset() + t2.getLength() == offset) {
                    return this.token2Region(t2, i - 1);
                }
                return this.token2Region(t, i);
            }
            return this.token2Region(t, i);
        }
        if (i < this.tokens.size() - 1) {
            PerlToken t2 = (PerlToken)((Object)this.tokens.get(i + 1));
            return new TypedRegion(t.getOffset() + t.getLength(), t2.getOffset() - (t.getOffset() + t.getLength()), "__dftl_partition_content_type");
        }
        return new TypedRegion(t.getOffset() + t.getLength(), this.doc.getLength() - (t.getOffset() + t.getLength()), "__dftl_partition_content_type");
    }

    private String getTokenContentType(PerlToken t, int i) {
        switch (t.getType()) {
            case 23: {
                return "COMMENT";
            }
            case 4: 
            case 5: 
            case 27: 
            case 28: 
            case 29: 
            case 77: {
                return "POD";
            }
            case 86: 
            case 88: 
            case 89: 
            case 102: {
                return "KEYWORD1";
            }
            case 87: {
                return "KEYWORD2";
            }
            case 70: 
            case 73: {
                return "VARIABLE";
            }
            case 31: 
            case 32: 
            case 33: {
                return "LITERAL1";
            }
            case 22: 
            case 50: 
            case 52: 
            case 53: 
            case 92: {
                return "LITERAL2";
            }
            case 9: 
            case 10: 
            case 11: {
                return i > 0 ? this.getTokenContentType((PerlToken)((Object)this.tokens.get(i - 1)), i - 1) : "__dftl_partition_content_type";
            }
            case 79: {
                return "NUMBER";
            }
        }
        if (t instanceof OperatorToken || t instanceof CurlyToken) {
            return "OPERATOR";
        }
        return "__dftl_partition_content_type";
    }

    private void initialize() {
        this.documentChanged2(new DocumentEvent(this.doc, 0, this.doc.getLength(), this.doc.get()));
    }

    private void dumpPartitioning(int offset, int length, boolean includeZeroLengthPartitions, ITypedRegion[] p) {
        System.err.println("computePartitioning " + includeZeroLengthPartitions + " " + offset + ":" + length + " start...");
        int i = 0;
        while (i < p.length) {
            System.err.println(String.valueOf(i) + ": " + p[i].getOffset() + ":" + p[i].getLength() + ":" + p[i].getType());
            ++i;
        }
        System.err.println("---- end of computePartitioning");
    }

    private PerlToken nextToken(PerlMultiLexer lexer) throws TokenStreamException {
        try {
            return (PerlToken)lexer.nextToken();
        }
        catch (TokenStreamException e) {
            lexer.recover();
            System.err.println("WARNING: PerlMultiLexer recovery performed at " + e.getMessage());
            return (PerlToken)lexer.nextToken();
        }
    }

    private TypedRegion token2Region(PerlToken t, int i) {
        return new TypedRegion(t.getOffset(), t.getLength(), this.getTokenContentType(t, i));
    }
}

