/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.varparser;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.varparser.PerlDebugValue;

public class PerlDebugVar
extends DebugElement
implements IVariable {
    public static final int LOCAL_SCOPE = 1;
    public static final int GLOBAL_SCOPE = 2;
    private final String name;
    private final int scope;
    private PerlDebugValue value;
    private int hasChanged;
    private boolean special;
    private boolean visited;
    private boolean isSet;

    public PerlDebugVar(IDebugTarget parent, int scope, String name, PerlDebugValue value) {
        super(parent);
        this.scope = scope;
        this.name = name;
        this.value = value;
        this.hasChanged = 0;
    }

    public boolean calculateChangeFlags(PerlDebugVar oldVar) {
        block4: {
            if (oldVar.visited) {
                return false;
            }
            oldVar.visited = true;
            try {
                if (this.getName().equals(oldVar.getName())) break block4;
                return false;
            }
            catch (DebugException e) {
                PerlDebugPlugin.log((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "PerlDebugVar.calculateChangeFlags failed", (Throwable)e));
                return false;
            }
        }
        int ret = this.value.calculateChangeFlags(oldVar.getPdValue());
        this.setChangeFlags(ret, false);
        return ret != 0;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public PerlDebugValue getPdValue() {
        return this.value;
    }

    public String getReferenceTypeName() throws DebugException {
        IValue value = this.getValue();
        return value != null ? value.getReferenceTypeName() : null;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public boolean hasContentChanged() throws DebugException {
        return (this.hasChanged & 1) > 0;
    }

    public boolean hasValueChanged() throws DebugException {
        return (this.hasChanged & 2) > 0;
    }

    public boolean isGlobalScope() {
        return this.scope == 2;
    }

    public boolean isLocalScope() {
        return this.scope == 1;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean matches(PerlDebugVar var) {
        if (!var.name.equals(this.name)) {
            return false;
        }
        return var.scope == this.scope;
    }

    public void setChangeFlags(int flags, boolean recurse) {
        if (this.isSet) {
            return;
        }
        this.isSet = true;
        this.hasChanged = flags;
        if (recurse) {
            this.value.setChangeFlags(flags, recurse);
        }
    }

    public void setSpecial() {
        this.special = true;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
        this.value = (PerlDebugValue)value;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public String toString() {
        return String.valueOf(this.name) + " = " + (Object)((Object)this.value);
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(PerlDebugValue value) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue fVal) {
        return false;
    }
}

