/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.jface.viewers.TableViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.InsertSQLInvoker;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableElementSearcher;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.core.UpdateSQLInvoker;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.event.PasteRecordMonitor;
import zigen.plugin.db.ui.editors.exceptions.UpdateException;
import zigen.plugin.db.ui.editors.internal.Messages;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;

public class RecordUpdateThread
implements Runnable {
    private ITableViewEditor editor;
    private TableViewer viewer;
    private TableElement element;
    private ITable table;

    public RecordUpdateThread(ITableViewEditor editor, TableElement element) {
        this.editor = editor;
        this.viewer = editor.getViewer();
        this.element = element;
        this.table = element.getTable();
    }

    public void run() {
        if (this.element.isModify()) {
            TransactionForTableEditor trans = null;
            int rowAffected = 0;
            try {
                trans = TransactionForTableEditor.getInstance(this.table.getDbConfig());
                rowAffected = this.element.isNew() ? this.insert(trans.getConnection()) : this.update(trans.getConnection());
                trans.commit();
                if (rowAffected == 0) {
                    SQLException ex = new SQLException(Messages.getString("RecordUpdateThread.2"));
                    throw ex;
                }
            }
            catch (Exception e) {
                if (trans != null) {
                    trans.rollback();
                }
                if (!PasteRecordMonitor.isPasting()) {
                    DbPlugin.getDefault().showErrorDialog(e);
                }
                throw new UpdateException(Messages.getString("RecordUpdateThread.0"), e.getCause());
            }
        }
    }

    private int insert(Connection con) throws Exception {
        int rowAffected = 0;
        rowAffected = InsertSQLInvoker.invoke(con, this.table, this.element.getColumns(), this.element.getItems());
        TableElement updatedElem = TableElementSearcher.findElement(con, this.element, true);
        if (updatedElem != null) {
            TableViewerManager.update(this.viewer, this.element, updatedElem);
        }
        return rowAffected;
    }

    private int update(Connection con) throws Exception {
        int rowAffected = 0;
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        rowAffected = UpdateSQLInvoker.invoke(con, this.table, this.element.getModifiedColumns(), this.element.getModifiedItems(), this.element.getUniqueColumns(), this.element.getUniqueItems());
        tw.stop();
        StringBuffer sb = new StringBuffer();
        if (rowAffected == 0) {
            sb.append(Messages.getString("RecordUpdateThread.3"));
            sb.append(Messages.getString("RecordUpdateThread.4"));
            DbPlugin.getDefault().showWarningMessage(sb.toString());
        } else if (rowAffected == 1) {
            tw.start();
            tw.stop();
            tw.start();
            TableElement updatedElem = TableElementSearcher.findElement(con, this.element, true);
            tw.stop();
            tw.start();
            if (updatedElem != null) {
                TableViewerManager.update(this.viewer, this.element, updatedElem);
            } else {
                sb.append(Messages.getString("RecordUpdateThread.5"));
                sb.append(Messages.getString("RecordUpdateThread.6"));
                DbPlugin.getDefault().showWarningMessage(sb.toString());
            }
            tw.stop();
        } else {
            sb.append(String.valueOf(Messages.getString("RecordUpdateThread.7")) + rowAffected + Messages.getString("RecordUpdateThread.8"));
            DbPlugin.getDefault().showWarningMessage(sb.toString());
            this.reload(con, this.table);
        }
        return rowAffected;
    }

    private void reload(Connection con, ITable table) throws Exception {
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        try {
            TableElement[] elements = TableManager.invoke(con, table, this.editor.getCondition());
            this.viewer.setInput((Object)elements);
        }
        catch (MaxRecordException e) {
            this.viewer.setInput((Object)e.getTableElements());
            DbPlugin.getDefault().showWarningMessage(e.getMessage());
        }
        this.viewer.refresh();
        tw.stop();
    }
}

