/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.stream;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;
import javolution.xml.stream.XMLStreamReaderImpl;

public abstract class XMLInputFactory {
    public static final Configurable<Class<? extends XMLInputFactory>> CLASS = new Configurable<Class<? extends XMLInputFactory>>(Default.class){};
    public static final String IS_COALESCING = "javolution.xml.stream.isCoalescing";
    public static final String ENTITIES = "javolution.xml.stream.entities";
    private static ObjectFactory XML_READER_FACTORY = new ObjectFactory(){

        protected Object create() {
            return new XMLStreamReaderImpl();
        }

        protected void cleanup(Object obj) {
            ((XMLStreamReaderImpl)obj).reset();
        }
    };

    protected XMLInputFactory() {
    }

    public static XMLInputFactory newInstance() {
        Class<? extends XMLInputFactory> cls = CLASS.get();
        return ObjectFactory.getInstance(cls).object();
    }

    public abstract XMLStreamReader createXMLStreamReader(Reader var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1) throws XMLStreamException;

    public abstract XMLStreamReader createXMLStreamReader(InputStream var1, String var2) throws XMLStreamException;

    public abstract void setProperty(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getProperty(String var1) throws IllegalArgumentException;

    public abstract boolean isPropertySupported(String var1);

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.class);
    }

    private static final class Default
    extends XMLInputFactory {
        Map _entities = null;

        private Default() {
        }

        @Override
        public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
            XMLStreamReaderImpl xmlReader = this.newReader();
            xmlReader.setInput(reader);
            return xmlReader;
        }

        @Override
        public XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
            XMLStreamReaderImpl xmlReader = this.newReader();
            xmlReader.setInput(stream);
            return xmlReader;
        }

        @Override
        public XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
            XMLStreamReaderImpl xmlReader = this.newReader();
            xmlReader.setInput(stream, encoding);
            return xmlReader;
        }

        @Override
        public void setProperty(String name, Object value) throws IllegalArgumentException {
            if (!name.equals(XMLInputFactory.IS_COALESCING)) {
                if (name.equals(XMLInputFactory.ENTITIES)) {
                    this._entities = (Map)value;
                } else {
                    throw new IllegalArgumentException("Property: " + name + " not supported");
                }
            }
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            if (name.equals(XMLInputFactory.IS_COALESCING)) {
                return Boolean.TRUE;
            }
            if (name.equals(XMLInputFactory.ENTITIES)) {
                return this._entities;
            }
            throw new IllegalArgumentException("Property: " + name + " not supported");
        }

        @Override
        public boolean isPropertySupported(String name) {
            return name.equals(XMLInputFactory.IS_COALESCING) || name.equals(XMLInputFactory.ENTITIES);
        }

        private XMLStreamReaderImpl newReader() {
            XMLStreamReaderImpl xmlReader = (XMLStreamReaderImpl)XML_READER_FACTORY.object();
            if (this._entities != null) {
                xmlReader.setEntities(this._entities);
            }
            xmlReader._objectFactory = XML_READER_FACTORY;
            return xmlReader;
        }
    }
}

