/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.Manager.favorite;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.communitybbs.Manager.favorite.BaseFavoriteManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.util.Util;

public class GrandBossRespawnTEST
extends BaseFavoriteManager {
    public static GrandBossRespawnTEST getInstance() {
        return new GrandBossRespawnTEST();
    }

    @Override
    public void parsecmd(String command, L2PcInstance activeChar) {
        String html = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/grand_boss_respawn/grandBossRespawnList.htm");
        StringBuilder tb = new StringBuilder(256);
        boolean isGM = activeChar.isGM();
        this.add(tb, isGM, 29001, new String[]{"ALIVE", "DEAD"});
        this.add(tb, isGM, 29006, new String[]{"ALIVE", "DEAD"});
        this.add(tb, isGM, 29014, new String[]{"ALIVE", "DEAD"});
        this.add(tb, isGM, 29019, new String[]{"DORMANT", "WAITING", "FIGHTING", "DEAD"});
        this.add(tb, isGM, 29020, new String[]{"ASLEEP", "AWAKE", "DEAD"});
        this.add(tb, isGM, 29022, new String[]{"ALIVE", "DEAD"});
        this.add(tb, isGM, 29028, new String[]{"DORMANT", "WAITING", "FIGHTING", "DEAD"});
        this.add(tb, isGM, 29045, new String[]{"DORMANT", "WAITING", "FIGHTING", "DEAD"});
        this.add(tb, isGM, 29062, new String[]{"DORMANT", "FIGHTING", "DEAD", "INTERVAL"});
        this.add(tb, isGM, 29065, new String[]{"DORMANT", "WAITING", "FIGHTING", "DEAD"});
        html = html.replace("%bossList%", tb.toString());
        this.separateAndSend(html, activeChar);
    }

    private void add(StringBuilder tb, boolean isGM, int bossId, String[] statusString) {
        if (GrandBossManager.getInstance().getStatsSet(bossId) == null) {
            return;
        }
        tb.append("<tr><td width=270 align=right><font color=\"00C3FF\">").append(NpcTable.getInstance().getTemplate(bossId).getName()).append("</font></td>");
        if (isGM) {
            tb.append("<td><font color=\"F9F999\">").append(statusString[GrandBossManager.getInstance().getBossStatus(bossId)]).append("</font></td>");
        }
        long respawnTime = bossId == 29019 ? this.getAntharasRespawnTime() : GrandBossManager.getInstance().getStatsSet(bossId).getLong("respawn_time");
        tb.append("<td width=270>");
        if (System.currentTimeMillis() < respawnTime) {
            tb.append("<font color=\"9CC300\">").append(Util.dateFormat(respawnTime)).append("</font>");
        } else {
            tb.append("<font color=\"32C332\">Alive</font>");
        }
        tb.append("</td></tr>");
    }

    @Override
    public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar) {
    }

    private long getAntharasRespawnTime() {
        int[] ANTHARAS;
        for (int antharasId : ANTHARAS = new int[]{29066, 29067, 29068, 29019}) {
            if (GrandBossManager.getInstance().getBossStatus(antharasId) == 0) continue;
            return GrandBossManager.getInstance().getStatsSet(antharasId).getLong("respawn_time");
        }
        return 0L;
    }
}

