/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DoorTable {
    private static final Logger _log = Logger.getLogger(DoorTable.class.getName());
    private final TIntObjectHashMap<L2DoorInstance> _staticItems;
    private final TIntObjectHashMap<ArrayList<L2DoorInstance>> _regions;

    public static DoorTable getInstance() {
        return SingletonHolder._instance;
    }

    private DoorTable() {
        _log.info("Initializing Door Table");
        this._staticItems = new TIntObjectHashMap();
        this._regions = new TIntObjectHashMap();
        this.parseData();
        this.onStart();
    }

    public void reloadAll() {
        this.respawn();
    }

    public void respawn() {
        this._staticItems.clear();
        this._regions.clear();
        this.parseData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseData() {
        BufferedReader lnr = null;
        try {
            File doorData = new File(Config.DATAPACK_ROOT, "data/door.csv");
            lnr = new LineNumberReader(new BufferedReader(new FileReader(doorData)));
            String line = null;
            _log.info("Searching clan halls doors:");
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                L2DoorInstance door = DoorTable.parseList(line, false);
                this.putDoor(door);
                door.spawnMe(door.getX(), door.getY(), door.getZ());
            }
            _log.info("DoorTable: Loaded " + this._staticItems.size() + " Door Templates for " + this._regions.size() + " regions.");
        }
        catch (FileNotFoundException e) {
            _log.warning("door.csv is missing in data folder");
        }
        catch (IOException e) {
            _log.log(Level.WARNING, "Error while creating door table " + e.getMessage(), e);
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e1) {}
        }
    }

    public static L2DoorInstance parseList(String line, boolean commanderDoor) {
        StringTokenizer st = new StringTokenizer(line, ";");
        L2DoorInstance door = null;
        try {
            ClanHall hall;
            String name = st.nextToken();
            int id = Integer.parseInt(st.nextToken());
            int x = Integer.parseInt(st.nextToken());
            int y = Integer.parseInt(st.nextToken());
            int z = Integer.parseInt(st.nextToken());
            int rangeXMin = Integer.parseInt(st.nextToken());
            int rangeYMin = Integer.parseInt(st.nextToken());
            int rangeZMin = Integer.parseInt(st.nextToken());
            int rangeXMax = Integer.parseInt(st.nextToken());
            int rangeYMax = Integer.parseInt(st.nextToken());
            int rangeZMax = Integer.parseInt(st.nextToken());
            int hp = Integer.parseInt(st.nextToken());
            int pdef = Integer.parseInt(st.nextToken());
            int mdef = Integer.parseInt(st.nextToken());
            int emitter = Integer.parseInt(st.nextToken());
            boolean unlockable = false;
            if (st.hasMoreTokens()) {
                unlockable = Boolean.parseBoolean(st.nextToken());
            }
            boolean startOpen = false;
            if (st.hasMoreTokens()) {
                startOpen = Boolean.parseBoolean(st.nextToken());
            }
            boolean targetable = true;
            if (st.hasMoreTokens()) {
                targetable = Boolean.parseBoolean(st.nextToken());
            }
            int hallId = 0;
            if (st.hasMoreTokens()) {
                hallId = Integer.parseInt(st.nextToken());
            }
            if (rangeXMin > rangeXMax) {
                _log.severe("Error in door data, XMin > XMax, ID:" + id);
            }
            if (rangeYMin > rangeYMax) {
                _log.severe("Error in door data, YMin > YMax, ID:" + id);
            }
            if (rangeZMin > rangeZMax) {
                _log.severe("Error in door data, ZMin > ZMax, ID:" + id);
            }
            int collisionRadius = rangeXMax - rangeXMin > rangeYMax - rangeYMin ? rangeYMax - rangeYMin : rangeXMax - rangeXMin;
            StatsSet npcDat = new StatsSet();
            npcDat.set("npcId", id);
            npcDat.set("level", 0);
            npcDat.set("jClass", "door");
            npcDat.set("baseSTR", 0);
            npcDat.set("baseCON", 0);
            npcDat.set("baseDEX", 0);
            npcDat.set("baseINT", 0);
            npcDat.set("baseWIT", 0);
            npcDat.set("baseMEN", 0);
            npcDat.set("baseShldDef", 0);
            npcDat.set("baseShldRate", 0);
            npcDat.set("baseAccCombat", 38);
            npcDat.set("baseEvasRate", 38);
            npcDat.set("baseCritRate", 38);
            npcDat.set("collision_radius", collisionRadius);
            npcDat.set("collision_height", rangeZMax - rangeZMin);
            npcDat.set("sex", "male");
            npcDat.set("type", "");
            npcDat.set("baseAtkRange", 0);
            npcDat.set("baseMpMax", 0);
            npcDat.set("baseCpMax", 0);
            npcDat.set("rewardExp", 0);
            npcDat.set("rewardSp", 0);
            npcDat.set("basePAtk", 0);
            npcDat.set("baseMAtk", 0);
            npcDat.set("basePAtkSpd", 0);
            npcDat.set("aggroRange", 0);
            npcDat.set("baseMAtkSpd", 0);
            npcDat.set("rhand", 0);
            npcDat.set("lhand", 0);
            npcDat.set("armor", 0);
            npcDat.set("baseWalkSpd", 0);
            npcDat.set("baseRunSpd", 0);
            npcDat.set("name", name);
            npcDat.set("baseHpMax", hp);
            npcDat.set("baseHpReg", 0.003f);
            npcDat.set("baseMpReg", 0.003f);
            npcDat.set("basePDef", pdef);
            npcDat.set("baseMDef", mdef);
            L2CharTemplate template = new L2CharTemplate(npcDat);
            door = new L2DoorInstance(IdFactory.getInstance().getNextId(), template, id, name, unlockable);
            door.setRange(rangeXMin, rangeYMin, rangeZMin, rangeXMax, rangeYMax, rangeZMax);
            door.setCurrentHpMp(door.getMaxHp(), door.getMaxMp());
            door.setXYZInvisible(x, y, z);
            door.setMapRegion(MapRegionManager.getInstance().getMapRegionLocId(x, y));
            door.setEmitter(emitter);
            door.setTargetable(targetable);
            if (hallId > 0 && (hall = ClanHallManager.getAllClanHalls().get(hallId)) != null) {
                door.setClanHall(hall);
                hall.getDoors().add(door);
                if (hall.isSiegableHall()) {
                    ((SiegableHall)hall).getDoorDefault().add(line);
                }
                if (Config.DEBUG) {
                    _log.info("door " + door.getDoorId() + "-" + door.getDoorName() + " attached to ch " + hall.getName());
                }
            }
            if (commanderDoor) {
                door.setIsCommanderDoor(startOpen);
            } else {
                door.setOpen(startOpen);
            }
            door.setLevel(unlockable ? 3 : 99);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error in door data at line: " + line, e);
        }
        return door;
    }

    public L2DoorInstance getDoor(int id) {
        return (L2DoorInstance)this._staticItems.get(id);
    }

    @Deprecated
    public L2DoorInstance getDoor(Integer id) {
        return (L2DoorInstance)this._staticItems.get(id.intValue());
    }

    public void putDoor(L2DoorInstance door) {
        this._staticItems.put(door.getDoorId(), (Object)door);
        if (this._regions.contains(door.getMapRegion())) {
            ((ArrayList)this._regions.get(door.getMapRegion())).add(door);
        } else {
            ArrayList<L2DoorInstance> region = new ArrayList<L2DoorInstance>();
            region.add(door);
            this._regions.put(door.getMapRegion(), region);
        }
    }

    public L2DoorInstance[] getDoors() {
        return (L2DoorInstance[])this._staticItems.values((Object[])new L2DoorInstance[0]);
    }

    public void checkAutoOpen() {
        for (L2DoorInstance doorInst : this.getDoors()) {
            if (doorInst.getDoorName().startsWith("goe")) {
                doorInst.setAutoActionDelay(420000);
                continue;
            }
            if (!doorInst.getDoorName().startsWith("aden_tower")) continue;
            doorInst.setAutoActionDelay(300000);
        }
    }

    public boolean checkIfDoorsBetween(AbstractNodeLoc start, AbstractNodeLoc end, int instanceId) {
        return this.checkIfDoorsBetween(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), instanceId);
    }

    public boolean checkIfDoorsBetween(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        ArrayList allDoors = instanceId > 0 && InstanceManager.getInstance().getInstance(instanceId) != null ? InstanceManager.getInstance().getInstance(instanceId).getDoors() : (ArrayList)this._regions.get(MapRegionManager.getInstance().getMapRegionLocId(x, y));
        if (allDoors == null) {
            return false;
        }
        for (L2DoorInstance doorInst : allDoors) {
            if (doorInst.getXMax() == 0 || (x > doorInst.getXMax() || tx < doorInst.getXMin()) && (tx > doorInst.getXMax() || x < doorInst.getXMin()) || (y > doorInst.getYMax() || ty < doorInst.getYMin()) && (ty > doorInst.getYMax() || y < doorInst.getYMin()) || !(doorInst.getCurrentHp() > 0.0) || doorInst.getOpen()) continue;
            int px1 = doorInst.getXMin();
            int py1 = doorInst.getYMin();
            int pz1 = doorInst.getZMin();
            int px2 = doorInst.getXMax();
            int py2 = doorInst.getYMax();
            int pz2 = doorInst.getZMax();
            int l = tx - x;
            int m = ty - y;
            int n = tz - z;
            int dk = doorInst.getA() * l + doorInst.getB() * m + doorInst.getC() * n;
            if (dk == 0) continue;
            float p = (float)(doorInst.getA() * x + doorInst.getB() * y + doorInst.getC() * z + doorInst.getD()) / (float)dk;
            int fx = (int)((float)x - (float)l * p);
            int fy = (int)((float)y - (float)m * p);
            int fz = (int)((float)z - (float)n * p);
            if (Math.min(x, tx) > fx || fx > Math.max(x, tx) || Math.min(y, ty) > fy || fy > Math.max(y, ty) || Math.min(z, tz) > fz || fz > Math.max(z, tz) || (fx < px1 || fx > px2) && (fx < px2 || fx > px1) || (fy < py1 || fy > py2) && (fy < py2 || fy > py1) || (fz < pz1 || fz > pz2) && (fz < pz2 || fz > pz1)) continue;
            return true;
        }
        return false;
    }

    private void onStart() {
        try {
            this.checkAutoOpen();
        }
        catch (NullPointerException e) {
            _log.log(Level.WARNING, "There are errors in your Door.csv file. Update door.csv", e);
        }
    }

    private static class SingletonHolder {
        protected static final DoorTable _instance = new DoorTable();

        private SingletonHolder() {
        }
    }
}

