/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.skills.funcs.LambdaConst;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnchantHPBonusData {
    protected static final Logger _log = Logger.getLogger(EnchantHPBonusData.class.getName());
    private final TIntObjectHashMap<Integer[]> _armorHPBonus = new TIntObjectHashMap();
    private static final float fullArmorModifier = 1.5f;

    public static final EnchantHPBonusData getInstance() {
        return SingletonHolder._instance;
    }

    private EnchantHPBonusData() {
        this.load();
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this._armorHPBonus.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/enchantHPBonus.xml");
        Document doc = null;
        if (file.exists()) {
            FuncTemplate ft;
            L2Item item;
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not parse enchantHPBonus.xml file: " + e.getMessage(), e);
            }
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"enchantHP".equalsIgnoreCase(d.getNodeName())) continue;
                    NamedNodeMap attrs = d.getAttributes();
                    Node att = attrs.getNamedItem("grade");
                    if (att == null) {
                        _log.severe("[EnchantHPBonusData] Missing grade, skipping");
                        continue;
                    }
                    Integer grade = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("values");
                    if (att == null) {
                        _log.severe("[EnchantHPBonusData] Missing bonus id: " + grade + ", skipping");
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(att.getNodeValue(), ",");
                    int tokenCount = st.countTokens();
                    Integer[] bonus = new Integer[tokenCount];
                    for (int i = 0; i < tokenCount; ++i) {
                        Integer value = Integer.decode(st.nextToken().trim());
                        if (value == null) {
                            _log.severe("[EnchantHPBonusData] Bad Hp value!! grade: " + grade + " token: " + i);
                            value = 0;
                        }
                        bonus[i] = value;
                    }
                    this._armorHPBonus.put(grade.intValue(), (Object)bonus);
                }
            }
            if (this._armorHPBonus.isEmpty()) {
                return;
            }
            Set<Integer> itemIds = ItemTable.getInstance().getAllArmorsId();
            int count = 0;
            for (Integer itemId : itemIds) {
                item = ItemTable.getInstance().getTemplate(itemId);
                if (item == null || item.getCrystalType() == 0) continue;
                switch (item.getBodyPart()) {
                    case 1: 
                    case 64: 
                    case 256: 
                    case 512: 
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: 
                    case 32768: {
                        ++count;
                        ft = new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0));
                        item.attach(ft);
                    }
                }
            }
            itemIds = ItemTable.getInstance().getAllWeaponsId();
            for (Integer itemId : itemIds) {
                item = ItemTable.getInstance().getTemplate(itemId);
                if (item == null || item.getCrystalType() == 0) continue;
                switch (item.getBodyPart()) {
                    case 256: {
                        ++count;
                        ft = new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0));
                        item.attach(ft);
                    }
                }
            }
            _log.info("Enchant HP Bonus registered for " + count + " items!");
        }
    }

    public final int getHPBonus(L2ItemInstance item) {
        Integer[] values = (Integer[])this._armorHPBonus.get(item.getItem().getItemGradeSPlus());
        if (values == null || values.length == 0) {
            return 0;
        }
        if (item.getItem().getBodyPart() == 32768) {
            return (int)((float)values[Math.min(item.getOlyEnchantLevel(), values.length) - 1].intValue() * 1.5f);
        }
        return values[Math.min(item.getOlyEnchantLevel(), values.length) - 1];
    }

    private static class SingletonHolder {
        protected static final EnchantHPBonusData _instance = new EnchantHPBonusData();

        private SingletonHolder() {
        }
    }
}

