/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.EnchantItem;
import com.l2jserver.gameserver.model.EnchantScroll;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnchantItemTable {
    private static final Logger _log = Logger.getLogger(EnchantItemTable.class.getName());
    public final TIntObjectHashMap<EnchantScroll> _scrolls = new TIntObjectHashMap();
    public final TIntObjectHashMap<EnchantItem> _supports = new TIntObjectHashMap();

    public EnchantItemTable() {
        this.load();
    }

    public void load() {
        try {
            this._scrolls.clear();
            this._supports.clear();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            File file = new File(Config.DATAPACK_ROOT + "/data/enchantData.xml");
            if (!file.exists()) {
                _log.log(Level.WARNING, "[" + this.getClass().getSimpleName() + "] File is missing " + Config.DATAPACK_ROOT + "/data/enchantData.xml !");
                return;
            }
            Document doc = factory.newDocumentBuilder().parse(file);
            Node first = doc.getFirstChild();
            if (first != null && "list".equalsIgnoreCase(first.getNodeName())) {
                for (Node n = first.getFirstChild(); n != null; n = n.getNextSibling()) {
                    boolean isWeapon;
                    int scrollId;
                    if ("enchant".equalsIgnoreCase(n.getNodeName())) {
                        scrollId = 0;
                        isWeapon = true;
                        boolean isBlessed = false;
                        boolean isCrystal = false;
                        boolean isSafe = false;
                        int type = 0;
                        int maxEnchant = 0;
                        double chance = Config.ENCHANT_CHANCE;
                        int[] items = null;
                        NamedNodeMap attrs = n.getAttributes();
                        Node att = attrs.getNamedItem("id");
                        if (att == null) {
                            _log.log(Level.WARNING, "[" + this.getClass().getSimpleName() + "] Missing Enchant id, skipping");
                            continue;
                        }
                        scrollId = Integer.parseInt(att.getNodeValue());
                        att = attrs.getNamedItem("isWeapon");
                        if (att != null) {
                            isWeapon = Boolean.parseBoolean(att.getNodeValue());
                        }
                        if ((att = attrs.getNamedItem("isBlessed")) != null) {
                            isBlessed = Boolean.parseBoolean(att.getNodeValue());
                        }
                        if ((att = attrs.getNamedItem("isCrystal")) != null) {
                            isCrystal = Boolean.parseBoolean(att.getNodeValue());
                        }
                        if ((att = attrs.getNamedItem("isSafe")) != null) {
                            isSafe = Boolean.parseBoolean(att.getNodeValue());
                        }
                        if ((att = attrs.getNamedItem("targetGrade")) != null) {
                            type = ItemTable._crystalTypes.get(att.getNodeValue());
                        }
                        if ((att = attrs.getNamedItem("maxEnchant")) != null) {
                            maxEnchant = Integer.parseInt(att.getNodeValue());
                        }
                        if ((att = attrs.getNamedItem("successRate")) != null) {
                            chance = Double.parseDouble(att.getNodeValue());
                            chance = Math.max(chance, 1.0);
                        }
                        ArrayList<Integer> itemz = new ArrayList<Integer>();
                        for (Node cd = n.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if (!"item".equalsIgnoreCase(cd.getNodeName())) continue;
                            att = cd.getAttributes().getNamedItem("id");
                            if (itemz != null) {
                                itemz.add(Integer.parseInt(att.getNodeValue()));
                                continue;
                            }
                            _log.log(Level.WARNING, "[" + this.getClass().getSimpleName() + "] Missing Item id, skipping");
                        }
                        if (itemz.size() > 0) {
                            items = new int[itemz.size()];
                            int i = 0;
                            for (Integer id : itemz) {
                                items[i++] = id;
                            }
                            Arrays.sort(items);
                        }
                        this._scrolls.put(scrollId, (Object)new EnchantScroll(isWeapon, isBlessed, isCrystal, isSafe, type, maxEnchant, chance, items));
                        continue;
                    }
                    if (!"support".equalsIgnoreCase(n.getNodeName())) continue;
                    scrollId = 0;
                    isWeapon = true;
                    int type = 0;
                    int maxEnchant = 0;
                    double chance = 1.0;
                    int[] items = null;
                    NamedNodeMap attrs = n.getAttributes();
                    Node att = attrs.getNamedItem("id");
                    if (att == null) {
                        _log.log(Level.WARNING, "[" + this.getClass().getSimpleName() + "] Missing Support id, skipping");
                        continue;
                    }
                    scrollId = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("isWeapon");
                    if (att != null) {
                        isWeapon = Boolean.parseBoolean(att.getNodeValue());
                    }
                    if ((att = attrs.getNamedItem("targetGrade")) != null) {
                        type = ItemTable._crystalTypes.get(att.getNodeValue());
                    }
                    if ((att = attrs.getNamedItem("maxEnchant")) != null) {
                        maxEnchant = Integer.parseInt(att.getNodeValue());
                    }
                    if ((att = attrs.getNamedItem("successBonus")) != null) {
                        chance = Double.parseDouble(att.getNodeValue());
                        chance = Math.max(chance, 1.0);
                    }
                    ArrayList<Integer> itemz = new ArrayList<Integer>();
                    for (Node cd = n.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                        if (!"item".equalsIgnoreCase(cd.getNodeName())) continue;
                        att = cd.getAttributes().getNamedItem("id");
                        if (itemz != null) {
                            itemz.add(Integer.parseInt(att.getNodeValue()));
                            continue;
                        }
                        _log.log(Level.WARNING, "[" + this.getClass().getSimpleName() + "] Missing Item id, skipping");
                    }
                    if (itemz.size() > 0) {
                        items = new int[itemz.size()];
                        int i = 0;
                        for (Integer id : itemz) {
                            items[i++] = id;
                        }
                        Arrays.sort(items);
                    }
                    this._supports.put(scrollId, (Object)new EnchantItem(isWeapon, type, maxEnchant, chance, items));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "[" + this.getClass().getSimpleName() + "] Failed to parse xml: " + e.getMessage(), e);
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._scrolls.size() + " Enchant Scrolls");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._supports.size() + " Support Items");
    }

    public final EnchantScroll getEnchantScroll(L2ItemInstance scroll) {
        return (EnchantScroll)this._scrolls.get(scroll.getItemId());
    }

    public final EnchantItem getSupportItem(L2ItemInstance item) {
        return (EnchantItem)this._supports.get(item.getItemId());
    }

    public static final EnchantItemTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemTable _instance = new EnchantItemTable();

        private SingletonHolder() {
        }
    }
}

