/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class NpcTable {
    private static Logger _log = Logger.getLogger(NpcTable.class.getName());
    private final TIntObjectHashMap<L2NpcTemplate> _npcs = new TIntObjectHashMap();

    public static NpcTable getInstance() {
        return SingletonHolder._instance;
    }

    private NpcTable() {
        this._npcs.clear();
        this.restoreNpcData();
    }

    private void restoreNpcData() {
        this.loadNpcs(0);
        this.loadNpcsSkills(0);
        this.loadNpcsDrop(0);
        this.loadNpcsSkillLearn(0);
        this.loadMinions(0);
        this.loadNpcsAI(0);
        this.loadNpcsElement(0);
    }

    private void fillNpcTable(ResultSet NpcData) throws Exception {
        StatsSet npcDat = new StatsSet();
        int id = NpcData.getInt("id");
        int idTemp = NpcData.getInt("idTemplate");
        assert (idTemp < 1000000);
        npcDat.set("npcId", id);
        npcDat.set("idTemplate", idTemp);
        int level = NpcData.getInt("level");
        npcDat.set("level", level);
        npcDat.set("client_class", NpcData.getString("class"));
        npcDat.set("baseShldDef", 0);
        npcDat.set("baseShldRate", 0);
        npcDat.set("baseCritRate", NpcData.getInt("critical"));
        npcDat.set("name", NpcData.getString("name"));
        npcDat.set("serverSideName", NpcData.getBoolean("serverSideName"));
        npcDat.set("title", NpcData.getString("title"));
        npcDat.set("serverSideTitle", NpcData.getBoolean("serverSideTitle"));
        npcDat.set("collision_radius", NpcData.getDouble("collision_radius"));
        npcDat.set("collision_height", NpcData.getDouble("collision_height"));
        npcDat.set("sex", NpcData.getString("sex"));
        npcDat.set("type", NpcData.getString("type"));
        npcDat.set("baseAtkRange", NpcData.getInt("attackrange"));
        npcDat.set("rewardExp", NpcData.getInt("exp"));
        npcDat.set("rewardSp", NpcData.getInt("sp"));
        npcDat.set("basePAtkSpd", NpcData.getInt("atkspd"));
        npcDat.set("baseMAtkSpd", NpcData.getInt("matkspd"));
        npcDat.set("rhand", NpcData.getInt("rhand"));
        npcDat.set("lhand", NpcData.getInt("lhand"));
        npcDat.set("enchant", NpcData.getInt("enchant"));
        npcDat.set("baseWalkSpd", NpcData.getInt("walkspd"));
        npcDat.set("baseRunSpd", NpcData.getInt("runspd"));
        npcDat.safeSet("baseSTR", NpcData.getInt("str"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseCON", NpcData.getInt("con"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseDEX", NpcData.getInt("dex"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseINT", NpcData.getInt("int"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseWIT", NpcData.getInt("wit"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.safeSet("baseMEN", NpcData.getInt("men"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
        npcDat.set("baseHpMax", NpcData.getDouble("hp"));
        npcDat.set("baseCpMax", 0);
        npcDat.set("baseMpMax", NpcData.getDouble("mp"));
        npcDat.set("baseHpReg", NpcData.getFloat("hpreg") > 0.0f ? (double)NpcData.getFloat("hpreg") : 1.5 + (double)(level - 1) / 10.0);
        npcDat.set("baseMpReg", NpcData.getFloat("mpreg") > 0.0f ? (double)NpcData.getFloat("mpreg") : 0.9 + 0.3 * ((double)(level - 1) / 10.0));
        npcDat.set("basePAtk", NpcData.getInt("patk"));
        npcDat.set("basePDef", NpcData.getInt("pdef"));
        npcDat.set("baseMAtk", NpcData.getInt("matk"));
        npcDat.set("baseMDef", NpcData.getInt("mdef"));
        npcDat.set("dropHerbGroup", NpcData.getInt("dropHerbGroup"));
        npcDat.set("baseFireRes", 20);
        npcDat.set("baseWindRes", 20);
        npcDat.set("baseWaterRes", 20);
        npcDat.set("baseEarthRes", 20);
        npcDat.set("baseHolyRes", 20);
        npcDat.set("baseDarkRes", 20);
        this._npcs.put(id, (Object)new L2NpcTemplate(npcDat));
    }

    public void reloadNpc(int id) {
        try {
            L2NpcTemplate old = this.getTemplate(id);
            TIntObjectHashMap skills = new TIntObjectHashMap();
            FastList minions = new FastList();
            FastMap quests = new FastMap();
            FastList classIds = new FastList();
            FastList categories = new FastList();
            if (old != null) {
                skills.putAll(old.getSkills());
                categories.addAll(old.getDropData());
                classIds.addAll(old.getTeachInfo());
                minions.addAll(old.getMinionData());
                if (!old.getEventQuests().isEmpty()) {
                    quests.putAll(old.getEventQuests());
                }
            }
            this.loadNpcs(id);
            this.loadNpcsSkills(id);
            this.loadNpcsDrop(id);
            this.loadNpcsSkillLearn(id);
            this.loadMinions(id);
            this.loadNpcsAI(id);
            this.loadNpcsElement(id);
            L2NpcTemplate created = this.getTemplate(id);
            if (old != null && created != null) {
                if (!skills.isEmpty()) {
                    for (L2Skill skill : (L2Skill[])skills.values((Object[])new L2Skill[0])) {
                        created.addSkill(skill);
                    }
                }
                for (ClassId classId : classIds) {
                    created.addTeachInfo(classId);
                }
                if (!minions.isEmpty()) {
                    for (L2MinionData minion : minions) {
                        created.addRaidData(minion);
                    }
                }
                if (!quests.isEmpty()) {
                    created.getEventQuests().putAll((Map<Quest.QuestEventType, Quest[]>)quests);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPCTable: Could not reload data for NPC " + id + ": " + e.getMessage(), e);
        }
    }

    public void reloadAllNpc() {
        this.restoreNpcData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNpc(StatsSet npc) {
        Map<String, Object> set = npc.getSet();
        int length = 0;
        for (String obj : set.keySet()) {
            length += obj.length() + 7 + 15;
        }
        StringBuilder sbValues = new StringBuilder(length);
        for (String obj : set.keySet()) {
            String name = obj;
            if (name.equalsIgnoreCase("npcId")) continue;
            if (sbValues.length() > 0) {
                sbValues.append(", ");
            }
            sbValues.append(name);
            sbValues.append(" = '");
            sbValues.append(set.get(name));
            sbValues.append('\'');
        }
        Connection con = null;
        try {
            PreparedStatement statement;
            StringBuilder sbQuery;
            con = L2DatabaseFactory.getInstance().getConnection();
            int updated = 0;
            if (Config.CUSTOM_NPC_TABLE) {
                sbQuery = new StringBuilder(sbValues.length() + 28);
                sbQuery.append("UPDATE custom_npc SET ");
                sbQuery.append(sbValues.toString());
                sbQuery.append(" WHERE id = ?");
                statement = con.prepareStatement(sbQuery.toString());
                statement.setInt(1, npc.getInteger("npcId"));
                updated = statement.executeUpdate();
                statement.close();
            }
            if (updated == 0) {
                sbQuery = new StringBuilder(sbValues.length() + 28);
                sbQuery.append("UPDATE npc SET ");
                sbQuery.append(sbValues.toString());
                sbQuery.append(" WHERE id = ?");
                statement = con.prepareStatement(sbQuery.toString());
                statement.setInt(1, npc.getInteger("npcId"));
                statement.executeUpdate();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPCTable: Could not store new NPC data in database: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public L2NpcTemplate getTemplate(int id) {
        return (L2NpcTemplate)this._npcs.get(id);
    }

    public L2NpcTemplate getTemplateByName(String name) {
        for (L2NpcTemplate npcTemplate : (L2NpcTemplate[])this._npcs.values((Object[])new L2NpcTemplate[0])) {
            if (!npcTemplate.getName().equalsIgnoreCase(name)) continue;
            return npcTemplate;
        }
        return null;
    }

    public List<L2NpcTemplate> getAllOfLevel(int lvl) {
        FastList list = new FastList();
        for (L2NpcTemplate t : this._npcs.valueCollection()) {
            if (t.getLevel() != lvl) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllOfLevel(int ... lvls) {
        FastList list = new FastList();
        for (int lvl : lvls) {
            for (L2NpcTemplate t : (L2NpcTemplate[])this._npcs.values((Object[])new L2NpcTemplate[0])) {
                if (t.getLevel() != lvl) continue;
                list.add(t);
            }
        }
        return list;
    }

    public List<L2NpcTemplate> getAllMonstersOfLevel(int lvl) {
        FastList list = new FastList();
        for (L2NpcTemplate t : this._npcs.valueCollection()) {
            if (t.getLevel() != lvl || !t.isType("L2Monster")) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllMonstersOfLevel(int ... lvls) {
        FastList list = new FastList();
        for (int lvl : lvls) {
            for (L2NpcTemplate t : (L2NpcTemplate[])this._npcs.values((Object[])new L2NpcTemplate[0])) {
                if (t.getLevel() != lvl || !t.isType("L2Monster")) continue;
                list.add(t);
            }
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcStartingWith(String letter) {
        FastList list = new FastList();
        for (L2NpcTemplate t : this._npcs.valueCollection()) {
            if (!t.getName().startsWith(letter) || !t.isType("L2Npc")) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcStartingWith(String ... letters) {
        FastList list = new FastList();
        for (String letter : letters) {
            for (L2NpcTemplate t : (L2NpcTemplate[])this._npcs.values((Object[])new L2NpcTemplate[0])) {
                if (!t.getName().startsWith(letter) || !t.isType("L2Npc")) continue;
                list.add(t);
            }
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcOfClassType(String classType) {
        FastList list = new FastList();
        for (L2NpcTemplate t : this._npcs.valueCollection()) {
            if (!t.isType(classType)) continue;
            list.add(t);
        }
        return list;
    }

    public List<L2NpcTemplate> getAllNpcOfClassType(String ... classTypes) {
        FastList list = new FastList();
        for (String classType : classTypes) {
            for (L2NpcTemplate t : (L2NpcTemplate[])this._npcs.values((Object[])new L2NpcTemplate[0])) {
                if (!t.isType(classType)) continue;
                list.add(t);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNpcs(int id) {
        Connection con = null;
        try {
            StringIntern.begin();
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (id > 0) {
                statement = con.prepareStatement("SELECT * FROM npc WHERE id = ?");
                statement.setInt(1, id);
            } else {
                statement = con.prepareStatement("SELECT * FROM npc ORDER BY id");
            }
            ResultSet rset = statement.executeQuery();
            int cont = 0;
            int cCont = 0;
            while (rset.next()) {
                this.fillNpcTable(rset);
                ++cont;
            }
            rset.close();
            statement.close();
            if (Config.CUSTOM_NPC_TABLE) {
                if (id > 0) {
                    statement = con.prepareStatement("SELECT * FROM custom_npc WHERE id = ?");
                    statement.setInt(1, id);
                } else {
                    statement = con.prepareStatement("SELECT * FROM custom_npc ORDER BY id");
                }
                rset = statement.executeQuery();
                while (rset.next()) {
                    this.fillNpcTable(rset);
                    ++cCont;
                }
                rset.close();
                statement.close();
            }
            _log.info("NpcTable: Loaded " + cont + " (Custom: " + cCont + ") NPC template(s).");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "NPCTable: Error creating NPC table.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
            StringIntern.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNpcsSkills(int id) {
        Connection con = null;
        try {
            int level;
            int skillId;
            int mobId;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (id > 0) {
                statement = con.prepareStatement("SELECT * FROM npcskills WHERE npcid = ?");
                statement.setInt(1, id);
            } else {
                statement = con.prepareStatement("SELECT * FROM npcskills ORDER BY npcid");
            }
            ResultSet rset = statement.executeQuery();
            int cont = 0;
            int cCont = 0;
            L2NpcTemplate npcDat = null;
            L2Skill npcSkill = null;
            while (rset.next()) {
                mobId = rset.getInt("npcid");
                npcDat = (L2NpcTemplate)this._npcs.get(mobId);
                if (npcDat == null) {
                    _log.warning("NPCTable: Skill data for undefined NPC. npcId: " + mobId);
                    continue;
                }
                skillId = rset.getInt("skillid");
                level = rset.getInt("level");
                if (skillId == 4416) {
                    npcDat.setRace(level);
                    continue;
                }
                npcSkill = SkillTable.getInstance().getInfo(skillId, level);
                if (npcSkill == null) continue;
                ++cont;
                npcDat.addSkill(npcSkill);
            }
            rset.close();
            statement.close();
            if (Config.CUSTOM_NPC_SKILLS_TABLE) {
                if (id > 0) {
                    statement = con.prepareStatement("SELECT * FROM custom_npcskills WHERE npcid = ?");
                    statement.setInt(1, id);
                } else {
                    statement = con.prepareStatement("SELECT * FROM custom_npcskills ORDER BY npcid");
                }
                rset = statement.executeQuery();
                while (rset.next()) {
                    mobId = rset.getInt("npcid");
                    npcDat = (L2NpcTemplate)this._npcs.get(mobId);
                    if (npcDat == null) {
                        _log.warning("Custom NPCTable: Skill data for undefined NPC. npcId: " + mobId);
                        continue;
                    }
                    skillId = rset.getInt("skillid");
                    level = rset.getInt("level");
                    if (npcDat.getRace() == null && skillId == 4416) {
                        npcDat.setRace(level);
                        continue;
                    }
                    npcSkill = SkillTable.getInstance().getInfo(skillId, level);
                    if (npcSkill == null) continue;
                    ++cCont;
                    npcDat.addSkill(npcSkill);
                }
                rset.close();
                statement.close();
            }
            _log.info("NpcTable: Loaded " + cont + " (Custom: " + cCont + ") npc skills.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "NPCTable: Error reading NPC skills table.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNpcsDrop(int id) {
        Connection con = null;
        try {
            int category;
            int mobId;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (id > 0) {
                statement = con.prepareStatement("SELECT * FROM droplist WHERE mobId = ? ORDER BY mobId, chance DESC");
                statement.setInt(1, id);
            } else {
                statement = con.prepareStatement("SELECT * FROM droplist ORDER BY mobId, chance DESC");
            }
            ResultSet rset = statement.executeQuery();
            L2DropData dropDat = null;
            L2NpcTemplate npcDat = null;
            int cont = 0;
            int cCont = 0;
            while (rset.next()) {
                mobId = rset.getInt("mobId");
                npcDat = (L2NpcTemplate)this._npcs.get(mobId);
                if (npcDat == null) {
                    _log.warning("NPCTable: Drop data for undefined NPC. npcId: " + mobId);
                    continue;
                }
                dropDat = new L2DropData();
                dropDat.setItemId(rset.getInt("itemId"));
                dropDat.setMinDrop(rset.getInt("min"));
                dropDat.setMaxDrop(rset.getInt("max"));
                dropDat.setChance(rset.getInt("chance"));
                category = rset.getInt("category");
                if (ItemTable.getInstance().getTemplate(dropDat.getItemId()) == null) {
                    _log.warning("Drop data for undefined item template! NpcId: " + mobId + " itemId: " + dropDat.getItemId());
                    continue;
                }
                ++cont;
                npcDat.addDropData(dropDat, category);
            }
            rset.close();
            statement.close();
            if (Config.CUSTOM_DROPLIST_TABLE) {
                if (id > 0) {
                    statement = con.prepareStatement("SELECT * FROM custom_droplist WHERE mobId = ? ORDER BY mobId, chance DESC");
                    statement.setInt(1, id);
                } else {
                    statement = con.prepareStatement("SELECT * FROM custom_droplist ORDER BY mobId, chance DESC");
                }
                rset = statement.executeQuery();
                while (rset.next()) {
                    mobId = rset.getInt("mobId");
                    npcDat = (L2NpcTemplate)this._npcs.get(mobId);
                    if (npcDat == null) {
                        _log.warning("NPCTable: CUSTOM DROPLIST: Drop data for undefined NPC. npcId: " + mobId);
                        continue;
                    }
                    dropDat = new L2DropData();
                    dropDat.setItemId(rset.getInt("itemId"));
                    dropDat.setMinDrop(rset.getInt("min"));
                    dropDat.setMaxDrop(rset.getInt("max"));
                    dropDat.setChance(rset.getInt("chance"));
                    category = rset.getInt("category");
                    if (ItemTable.getInstance().getTemplate(dropDat.getItemId()) == null) {
                        _log.warning("Custom drop data for undefined item template! NpcId: " + mobId + " itemId: " + dropDat.getItemId());
                        continue;
                    }
                    npcDat.addDropData(dropDat, category);
                    ++cCont;
                }
                rset.close();
                statement.close();
            }
            _log.info("NpcTable: Loaded " + cont + " (Custom: " + cCont + ") drops.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "NPCTable: Error reading NPC dropdata. ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNpcsSkillLearn(int id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (id > 0) {
                statement = con.prepareStatement("SELECT * FROM skill_learn WHERE npc_id = ?");
                statement.setInt(1, id);
            } else {
                statement = con.prepareStatement("SELECT * FROM skill_learn");
            }
            ResultSet rset = statement.executeQuery();
            int cont = 0;
            while (rset.next()) {
                int npcId = rset.getInt("npc_id");
                int classId = rset.getInt("class_id");
                L2NpcTemplate npc = this.getTemplate(npcId);
                if (npc == null) {
                    _log.warning("NPCTable: Error getting NPC template ID " + npcId + " while trying to load skill trainer data.");
                    continue;
                }
                ++cont;
                npc.addTeachInfo(ClassId.values()[classId]);
            }
            rset.close();
            statement.close();
            _log.info("NpcTable: Loaded " + cont + " Skill Learn.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "NPCTable: Error reading NPC trainer data.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMinions(int id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (id > 0) {
                statement = con.prepareStatement("SELECT * FROM minions WHERE boss_id = ?");
                statement.setInt(1, id);
            } else {
                statement = con.prepareStatement("SELECT * FROM minions ORDER BY boss_id");
            }
            ResultSet rset = statement.executeQuery();
            L2MinionData minionDat = null;
            L2NpcTemplate npcDat = null;
            int cnt = 0;
            while (rset.next()) {
                int raidId = rset.getInt("boss_id");
                npcDat = (L2NpcTemplate)this._npcs.get(raidId);
                if (npcDat == null) {
                    _log.warning("Minion references undefined boss NPC. Boss NpcId: " + raidId);
                    continue;
                }
                minionDat = new L2MinionData();
                minionDat.setMinionId(rset.getInt("minion_id"));
                minionDat.setAmountMin(rset.getInt("amount_min"));
                minionDat.setAmountMax(rset.getInt("amount_max"));
                npcDat.addRaidData(minionDat);
                ++cnt;
            }
            rset.close();
            statement.close();
            _log.info("NpcTable: Loaded " + cnt + " Minions.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "NPCTable: Error loading minion data.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNpcsAI(int id) {
        Connection con = null;
        try {
            int npc_id;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (id > 0) {
                statement = con.prepareStatement("SELECT * FROM npcaidata WHERE npcId = ?");
                statement.setInt(1, id);
            } else {
                statement = con.prepareStatement("SELECT * FROM npcaidata ORDER BY npcId");
            }
            ResultSet rset = statement.executeQuery();
            L2NpcAIData npcAIDat = null;
            L2NpcTemplate npcDat = null;
            int cont = 0;
            int cCont = 0;
            while (rset.next()) {
                npc_id = rset.getInt("npcId");
                npcDat = (L2NpcTemplate)this._npcs.get(npc_id);
                if (npcDat == null) {
                    _log.severe("NPCTable: AI Data Error with id : " + npc_id);
                    continue;
                }
                npcAIDat = new L2NpcAIData();
                npcAIDat.setPrimarySkillId(rset.getInt("primarySkillId"));
                npcAIDat.setMinSkillChance(rset.getInt("minSkillChance"));
                npcAIDat.setMaxSkillChance(rset.getInt("maxSkillChance"));
                npcAIDat.setAggro(rset.getInt("aggro"));
                npcAIDat.setCanMove(rset.getInt("canMove"));
                npcAIDat.setShowName(rset.getBoolean("showName"));
                npcAIDat.setTargetable(rset.getBoolean("targetable"));
                npcAIDat.setSoulShot(rset.getInt("soulshot"));
                npcAIDat.setSpiritShot(rset.getInt("spiritshot"));
                npcAIDat.setSoulShotChance(rset.getInt("ssChance"));
                npcAIDat.setSpiritShotChance(rset.getInt("spsChance"));
                npcAIDat.setIsChaos(rset.getInt("isChaos"));
                npcAIDat.setShortRangeSkill(rset.getInt("minRangeSkill"));
                npcAIDat.setShortRangeChance(rset.getInt("minRangeChance"));
                npcAIDat.setLongRangeSkill(rset.getInt("maxRangeSkill"));
                npcAIDat.setLongRangeChance(rset.getInt("maxRangeChance"));
                npcAIDat.setClan(rset.getString("clan"));
                npcAIDat.setClanRange(rset.getInt("clanRange"));
                npcAIDat.setEnemyClan(rset.getString("enemyClan"));
                npcAIDat.setEnemyRange(rset.getInt("enemyRange"));
                npcAIDat.setDodge(rset.getInt("dodge"));
                npcAIDat.setAi(rset.getString("aiType"));
                npcDat.setAIData(npcAIDat);
                ++cont;
            }
            rset.close();
            statement.close();
            if (Config.CUSTOM_NPC_TABLE) {
                if (id > 0) {
                    statement = con.prepareStatement("SELECT * FROM custom_npcaidata WHERE npcId = ?");
                    statement.setInt(1, id);
                } else {
                    statement = con.prepareStatement("SELECT * FROM custom_npcaidata ORDER BY npcId");
                }
                rset = statement.executeQuery();
                while (rset.next()) {
                    npc_id = rset.getInt("npcId");
                    npcDat = (L2NpcTemplate)this._npcs.get(npc_id);
                    if (npcDat == null) {
                        _log.severe("NPCTable: Custom AI Data Error with id : " + npc_id);
                        continue;
                    }
                    npcAIDat = new L2NpcAIData();
                    npcAIDat.setPrimarySkillId(rset.getInt("primarySkillId"));
                    npcAIDat.setMinSkillChance(rset.getInt("minSkillChance"));
                    npcAIDat.setMaxSkillChance(rset.getInt("maxSkillChance"));
                    npcAIDat.setAggro(rset.getInt("aggro"));
                    npcAIDat.setCanMove(rset.getInt("canMove"));
                    npcAIDat.setShowName(rset.getBoolean("showName"));
                    npcAIDat.setTargetable(rset.getBoolean("targetable"));
                    npcAIDat.setSoulShot(rset.getInt("soulshot"));
                    npcAIDat.setSpiritShot(rset.getInt("spiritshot"));
                    npcAIDat.setSoulShotChance(rset.getInt("ssChance"));
                    npcAIDat.setSpiritShotChance(rset.getInt("spsChance"));
                    npcAIDat.setIsChaos(rset.getInt("isChaos"));
                    npcAIDat.setShortRangeSkill(rset.getInt("minRangeSkill"));
                    npcAIDat.setShortRangeChance(rset.getInt("minRangeChance"));
                    npcAIDat.setLongRangeSkill(rset.getInt("maxRangeSkill"));
                    npcAIDat.setLongRangeChance(rset.getInt("maxRangeChance"));
                    npcAIDat.setClan(rset.getString("clan"));
                    npcAIDat.setClanRange(rset.getInt("clanRange"));
                    npcAIDat.setEnemyClan(rset.getString("enemyClan"));
                    npcAIDat.setEnemyRange(rset.getInt("enemyRange"));
                    npcAIDat.setDodge(rset.getInt("dodge"));
                    npcAIDat.setAi(rset.getString("aiType"));
                    npcDat.setAIData(npcAIDat);
                    ++cCont;
                }
                rset.close();
                statement.close();
            }
            _log.info("NpcTable: Loaded " + cont + " (Custom: " + cCont + ") AI Data.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "NPCTable: Error reading NPC AI Data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNpcsElement(int id) {
        Connection con = null;
        try {
            int npc_id;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (id > 0) {
                statement = con.prepareStatement("SELECT * FROM npc_elementals WHERE npc_id = ?");
                statement.setInt(1, id);
            } else {
                statement = con.prepareStatement("SELECT * FROM npc_elementals ORDER BY npc_id");
            }
            ResultSet rset = statement.executeQuery();
            L2NpcTemplate npcDat = null;
            int cont = 0;
            int cCount = 0;
            block21: while (rset.next()) {
                npc_id = rset.getInt("npc_id");
                npcDat = (L2NpcTemplate)this._npcs.get(npc_id);
                if (npcDat == null) {
                    _log.severe("NPCElementals: Elementals Error with id : " + npc_id);
                    continue;
                }
                switch (rset.getByte("elemAtkType")) {
                    case 0: {
                        npcDat.setBaseFire(rset.getInt("elemAtkValue"));
                        break;
                    }
                    case 1: {
                        npcDat.setBaseWater(rset.getInt("elemAtkValue"));
                        break;
                    }
                    case 3: {
                        npcDat.setBaseEarth(rset.getInt("elemAtkValue"));
                        break;
                    }
                    case 2: {
                        npcDat.setBaseWind(rset.getInt("elemAtkValue"));
                        break;
                    }
                    case 4: {
                        npcDat.setBaseHoly(rset.getInt("elemAtkValue"));
                        break;
                    }
                    case 5: {
                        npcDat.setBaseDark(rset.getInt("elemAtkValue"));
                        break;
                    }
                    default: {
                        _log.severe("NPCElementals: Elementals Error with id : " + npc_id + "; unknown elementType: " + rset.getByte("elemAtkType"));
                        continue block21;
                    }
                }
                npcDat.setBaseFireRes(rset.getInt("fireDefValue"));
                npcDat.setBaseWaterRes(rset.getInt("waterDefValue"));
                npcDat.setBaseEarthRes(rset.getInt("earthDefValue"));
                npcDat.setBaseWindRes(rset.getInt("windDefValue"));
                npcDat.setBaseHolyRes(rset.getInt("holyDefValue"));
                npcDat.setBaseDarkRes(rset.getInt("darkDefValue"));
                ++cont;
            }
            rset.close();
            statement.close();
            if (Config.CUSTOM_NPC_TABLE) {
                if (id > 0) {
                    statement = con.prepareStatement("SELECT * FROM custom_npc_elementals WHERE npc_id = ?");
                    statement.setInt(1, id);
                } else {
                    statement = con.prepareStatement("SELECT * FROM custom_npc_elementals ORDER BY npc_id");
                }
                rset = statement.executeQuery();
                block22: while (rset.next()) {
                    npc_id = rset.getInt("npc_id");
                    npcDat = (L2NpcTemplate)this._npcs.get(npc_id);
                    if (npcDat == null) {
                        _log.severe("NPCElementals: Custom Elementals Error with id : " + npc_id);
                        continue;
                    }
                    switch (rset.getByte("elemAtkType")) {
                        case 0: {
                            npcDat.setBaseFire(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 1: {
                            npcDat.setBaseWater(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 3: {
                            npcDat.setBaseEarth(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 2: {
                            npcDat.setBaseWind(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 4: {
                            npcDat.setBaseHoly(rset.getInt("elemAtkValue"));
                            break;
                        }
                        case 5: {
                            npcDat.setBaseDark(rset.getInt("elemAtkValue"));
                            break;
                        }
                        default: {
                            _log.severe("NPCElementals: Custom Elementals Error with id : " + npc_id + "; unknown elementType: " + rset.getByte("elemAtkType"));
                            continue block22;
                        }
                    }
                    npcDat.setBaseFireRes(rset.getInt("fireDefValue"));
                    npcDat.setBaseWaterRes(rset.getInt("waterDefValue"));
                    npcDat.setBaseEarthRes(rset.getInt("earthDefValue"));
                    npcDat.setBaseWindRes(rset.getInt("windDefValue"));
                    npcDat.setBaseHolyRes(rset.getInt("holyDefValue"));
                    npcDat.setBaseDarkRes(rset.getInt("darkDefValue"));
                    ++cont;
                }
                rset.close();
                statement.close();
            }
            _log.info("NpcTable: Loaded " + cont + " (Custom: " + cCount + ") elementals Data.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "NPCTable: Error reading NPC Elementals Data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private static class SingletonHolder {
        protected static final NpcTable _instance = new NpcTable();

        private SingletonHolder() {
        }
    }
}

