/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.io.UTF8StreamWriter;
import javolution.util.FastSet;

public class SpawnTable {
    private static Logger _log = Logger.getLogger(SpawnTable.class.getName());
    private FastSet<L2Spawn> _spawntable = new FastSet().shared();
    private int _npcSpawnCount;
    private int _customSpawnCount;

    public static SpawnTable getInstance() {
        return SingletonHolder._instance;
    }

    private SpawnTable() {
        if (!Config.ALT_DEV_NO_SPAWNS) {
            this.fillSpawnTable();
        }
    }

    public FastSet<L2Spawn> getSpawnTable() {
        return this._spawntable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSpawnTable() {
        int loc_id;
        L2Spawn spawnDat;
        L2NpcTemplate template1;
        ResultSet rset;
        PreparedStatement statement;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT count, npc_templateid, locx, locy, locz, heading, respawn_delay, loc_id, periodOfDay FROM spawnlist");
            rset = statement.executeQuery();
            while (rset.next()) {
                template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    if (template1.isType("L2SiegeGuard") || template1.isType("L2RaidBoss") || !Config.ALLOW_CLASS_MASTERS && template1.isType("L2ClassMaster")) continue;
                    spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    loc_id = rset.getInt("loc_id");
                    spawnDat.setLocation(loc_id);
                    switch (rset.getInt("periodOfDay")) {
                        case 0: {
                            this._npcSpawnCount += spawnDat.init();
                            break;
                        }
                        case 1: {
                            DayNightSpawnManager.getInstance().addDayCreature(spawnDat);
                            ++this._npcSpawnCount;
                            break;
                        }
                        case 2: {
                            DayNightSpawnManager.getInstance().addNightCreature(spawnDat);
                            ++this._npcSpawnCount;
                        }
                    }
                    this._spawntable.add((Object)spawnDat);
                    continue;
                }
                _log.warning("SpawnTable: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "SpawnTable: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.info("SpawnTable: Loaded " + this._spawntable.size() + " Npc Spawn Locations.");
        if (Config.CUSTOM_SPAWNLIST_TABLE) {
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("SELECT count, npc_templateid, locx, locy, locz, heading, respawn_delay, loc_id, periodOfDay FROM custom_spawnlist");
                rset = statement.executeQuery();
                while (rset.next()) {
                    template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                    if (template1 != null) {
                        if (template1.isType("L2SiegeGuard") || template1.isType("L2RaidBoss") || !Config.ALLOW_CLASS_MASTERS && template1.isType("L2ClassMaster")) continue;
                        spawnDat = new L2Spawn(template1);
                        spawnDat.setAmount(rset.getInt("count"));
                        spawnDat.setLocx(rset.getInt("locx"));
                        spawnDat.setLocy(rset.getInt("locy"));
                        spawnDat.setLocz(rset.getInt("locz"));
                        spawnDat.setHeading(rset.getInt("heading"));
                        spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                        spawnDat.setCustom(true);
                        loc_id = rset.getInt("loc_id");
                        spawnDat.setLocation(loc_id);
                        switch (rset.getInt("periodOfDay")) {
                            case 0: {
                                this._customSpawnCount += spawnDat.init();
                                break;
                            }
                            case 1: {
                                DayNightSpawnManager.getInstance().addDayCreature(spawnDat);
                                ++this._customSpawnCount;
                                break;
                            }
                            case 2: {
                                DayNightSpawnManager.getInstance().addNightCreature(spawnDat);
                                ++this._customSpawnCount;
                            }
                        }
                        this._spawntable.add((Object)spawnDat);
                        continue;
                    }
                    _log.warning("CustomSpawnTable: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
                }
                rset.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "CustomSpawnTable: Spawn could not be initialized: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            _log.info("CustomSpawnTable: Loaded " + this._customSpawnCount + " Npc Spawn Locations.");
        }
        if (Config.DEBUG) {
            _log.fine("SpawnTable: Spawning completed, total number of NPCs in the world: " + (this._npcSpawnCount + this._customSpawnCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSpawn(L2Spawn spawn, boolean storeInDb) {
        this._spawntable.add((Object)spawn);
        if (storeInDb) {
            String spawnTable = spawn.isCustom() && Config.CUSTOM_SPAWNLIST_TABLE ? "custom_spawnlist" : "spawnlist";
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("INSERT INTO " + spawnTable + "(count,npc_templateid,locx,locy,locz,heading,respawn_delay,loc_id) values(?,?,?,?,?,?,?,?)");
                statement.setInt(1, spawn.getAmount());
                statement.setInt(2, spawn.getNpcid());
                statement.setInt(3, spawn.getLocx());
                statement.setInt(4, spawn.getLocy());
                statement.setInt(5, spawn.getLocz());
                statement.setInt(6, spawn.getHeading());
                statement.setInt(7, spawn.getRespawnDelay() / 1000);
                statement.setInt(8, spawn.getLocation());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "SpawnTable: Could not store spawn in the DB:" + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            String zoneName = MapRegionManager.getInstance().getClosestTownName(spawn.getLocx(), spawn.getLocy());
            SpawnTable.addSqlLog("-- " + Util.dateFormat() + " " + spawn.getTemplate().getTitle() + " " + spawn.getTemplate().getName() + " - " + zoneName + "\r\n" + "INSERT INTO " + spawnTable + " SET location='//spawn." + zoneName + "'" + ", count=" + spawn.getAmount() + ", npc_templateid=" + spawn.getNpcid() + ", locx=" + spawn.getLocx() + ", locy=" + spawn.getLocy() + ", locz=" + spawn.getLocz() + ", heading=" + spawn.getHeading() + ", respawn_delay=" + spawn.getRespawnDelay() / 1000 + ", loc_id=" + spawn.getLocation() + ";\r\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpawn(L2Spawn spawn, boolean updateDb) {
        if (!this._spawntable.remove((Object)spawn)) {
            return;
        }
        if (updateDb) {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("DELETE FROM " + (spawn.isCustom() ? "custom_spawnlist" : "spawnlist") + " WHERE locx=? AND locy=? AND locz=? AND npc_templateid=? AND heading=?");
                statement.setInt(1, spawn.getLocx());
                statement.setInt(2, spawn.getLocy());
                statement.setInt(3, spawn.getLocz());
                statement.setInt(4, spawn.getNpcid());
                statement.setInt(5, spawn.getHeading());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "SpawnTable: Spawn " + spawn + " could not be removed from DB: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            String zoneName = MapRegionManager.getInstance().getClosestTownName(spawn.getLocx(), spawn.getLocy());
            SpawnTable.addSqlLog("-- " + Util.dateFormat() + " " + spawn.getTemplate().getTitle() + " " + spawn.getTemplate().getName() + " - " + zoneName + "\r\n" + "DELETE FROM " + (spawn.isCustom() ? "custom_spawnlist" : "spawnlist") + " WHERE locx=" + spawn.getLocx() + " AND locy=" + spawn.getLocy() + " AND locz=" + spawn.getLocz() + " AND npc_templateid=" + spawn.getNpcid() + " AND heading=" + spawn.getHeading() + ";\r\n");
        }
    }

    public void reloadAll() {
        this.fillSpawnTable();
    }

    public void findNPCInstances(L2PcInstance activeChar, int npcId, int teleportIndex, boolean showposition) {
        int index = 0;
        for (L2Spawn spawn : this._spawntable) {
            if (npcId != spawn.getNpcid()) continue;
            ++index;
            L2Npc _npc = spawn.getLastSpawn();
            if (teleportIndex > -1) {
                if (teleportIndex != index) continue;
                if (showposition && _npc != null) {
                    this.meet(activeChar, spawn);
                    continue;
                }
                activeChar.teleToLocation(spawn.getLocx(), spawn.getLocy(), spawn.getLocz(), true);
                continue;
            }
            if (index == 1) {
                activeChar.sendMessage(spawn.getNpcid() + " " + spawn.getTemplate().getName());
            }
            if (showposition && _npc != null) {
                activeChar.sendMessage("- " + index + ". " + _npc.getX() + " " + _npc.getY() + " " + _npc.getZ());
                continue;
            }
            activeChar.sendMessage("- " + index + ". " + spawn.getLocx() + " " + spawn.getLocy() + " " + spawn.getLocz());
        }
        if (index == 0) {
            activeChar.sendMessage("No current spawns found.");
        }
    }

    private void meet(L2PcInstance activeChar, L2Spawn spawn) {
        int z;
        int y;
        int x;
        L2Npc npc = spawn.getLastSpawn();
        if (npc != null && npc.isVisible()) {
            double a = (double)npc.getHeading() * 9.587379924285257E-5;
            double r = Math.max(npc.getCollisionRadius(), npc.getCollisionHeight()) + activeChar.getCollisionRadius() + 60.0;
            x = npc.getX() + (int)Math.ceil(r * Math.cos(a));
            y = npc.getY() + (int)Math.ceil(r * Math.sin(a));
            z = npc.getZ();
        } else {
            x = spawn.getLocx();
            y = spawn.getLocy();
            z = spawn.getLocz();
        }
        activeChar.teleToLocation(x, y, z, false);
    }

    public void addNewSpawnOne(L2Npc npc) {
        int npcId = npc.getNpcId();
        Iterator it = this._spawntable.iterator();
        while (it.hasNext()) {
            L2Spawn spawn = (L2Spawn)it.next();
            if (spawn.getNpcid() != npcId) continue;
            it.remove();
        }
        this.addNewSpawn(npc.getSpawn(), false);
    }

    public void deleteSpawnOne(L2Npc npc) {
        this._spawntable.remove((Object)npc.getSpawn());
    }

    public L2Spawn getSpawnOne(int npcId) {
        for (L2Spawn spawn : this._spawntable) {
            if (spawn.getNpcid() != npcId) continue;
            return spawn;
        }
        return null;
    }

    private static void addSqlLog(String sql) {
        System.out.print(sql);
        try {
            UTF8StreamWriter save = Util.utf8StreamWriter("log/_spawnlist.sql", true);
            save.write(sql);
            save.flush();
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class SingletonHolder {
        protected static final SpawnTable _instance = new SpawnTable();

        private SingletonHolder() {
        }
    }
}

