/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class EffectHandler {
    private static final Logger _log = Logger.getLogger(EffectHandler.class.getName());
    private final FastMap<Integer, Class<? extends L2Effect>> _handlers = new FastMap();

    private EffectHandler() {
    }

    public void registerHandler(String name, Class<? extends L2Effect> func) {
        this._handlers.put((Object)name.hashCode(), func);
    }

    public final Class<? extends L2Effect> getHandler(String name) {
        return (Class)this._handlers.get((Object)name.hashCode());
    }

    public int size() {
        return this._handlers.size();
    }

    public void executeScript() {
        try {
            File file = new File(L2ScriptEngineManager.SCRIPT_FOLDER, "handlers/EffectMasterHandler.java");
            L2ScriptEngineManager.getInstance().executeScript(file);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Problems while running EffectMansterHandler", e);
        }
        _log.config("Loaded " + this.size() + " Effect handlers");
    }

    public static EffectHandler getInstance() {
        return SingletonHolder._instance;
    }

    private static final class SingletonHolder {
        private static final EffectHandler _instance = new EffectHandler();

        private SingletonHolder() {
        }
    }
}

