/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.GlobalVariablesManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;
import javolution.util.FastList;

public class HellboundManager {
    private static final Logger _log = Logger.getLogger(HellboundManager.class.getName());
    private static final String LOAD_SPAWNS = "SELECT npc_templateid, locx, locy, locz, heading, respawn_delay, respawn_random, min_hellbound_level, max_hellbound_level FROM hellbound_spawnlist ORDER BY npc_templateid";
    private int _level = 0;
    private int _trust = 0;
    private int _maxTrust = 0;
    private int _minTrust = 0;
    private ScheduledFuture<?> _engine = null;
    private final List<HellboundSpawn> _population = new FastList();

    private HellboundManager() {
        this.loadData();
        this.loadSpawns();
    }

    public final int getLevel() {
        return this._level;
    }

    public final synchronized void updateTrust(int t, boolean useRates) {
        if (this.isLocked()) {
            return;
        }
        int reward = t;
        if (useRates) {
            reward = (int)(t > 0 ? Config.RATE_HB_TRUST_INCREASE * (float)t : Config.RATE_HB_TRUST_DECREASE * (float)t);
        }
        int trust = Math.max(this._trust + reward, this._minTrust);
        this._trust = this._maxTrust > 0 ? Math.min(trust, this._maxTrust) : trust;
    }

    public final void setLevel(int lvl) {
        this._level = lvl;
    }

    public final int getTrust() {
        return this._trust;
    }

    public final int getMaxTrust() {
        return this._maxTrust;
    }

    public final int getMinTrust() {
        return this._minTrust;
    }

    public final void setMaxTrust(int trust) {
        this._maxTrust = trust;
        if (this._maxTrust > 0 && this._trust > this._maxTrust) {
            this._trust = this._maxTrust;
        }
    }

    public final void setMinTrust(int trust) {
        this._minTrust = trust;
        if (this._trust >= this._maxTrust) {
            this._trust = this._minTrust;
        }
    }

    public final boolean isLocked() {
        return this._level == 0;
    }

    public final void unlock() {
        if (this._level == 0) {
            this.setLevel(1);
        }
    }

    public final void registerEngine(Runnable r, int interval) {
        if (this._engine != null) {
            this._engine.cancel(false);
        }
        this._engine = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(r, interval, interval);
    }

    public final void doSpawn() {
        int added = 0;
        int deleted = 0;
        for (HellboundSpawn spawnDat : this._population) {
            try {
                if (spawnDat == null) continue;
                L2Npc npc = spawnDat.getLastSpawn();
                if (this._level < spawnDat.getMinLvl() || this._level > spawnDat.getMaxLvl()) {
                    spawnDat.stopRespawn();
                    if (npc == null || !npc.isVisible()) continue;
                    npc.deleteMe();
                    ++deleted;
                    continue;
                }
                spawnDat.startRespawn();
                npc = spawnDat.getLastSpawn();
                if (npc == null) {
                    npc = spawnDat.doSpawn();
                    ++added;
                    continue;
                }
                if (npc.isDecayed()) {
                    npc.setDecayed(false);
                }
                if (npc.isDead()) {
                    npc.doRevive();
                }
                if (!npc.isVisible()) {
                    ++added;
                }
                npc.setCurrentHp(npc.getMaxHp());
                npc.setCurrentMp(npc.getMaxMp());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (added > 0) {
            _log.info("HellboundManager: Spawned " + added + " NPCs.");
        }
        if (deleted > 0) {
            _log.info("HellboundManager: Removed " + deleted + " NPCs.");
        }
    }

    public final void cleanUp() {
        this.saveData();
        if (this._engine != null) {
            this._engine.cancel(true);
            this._engine = null;
        }
        this._population.clear();
    }

    private final void loadData() {
        if (GlobalVariablesManager.getInstance().isVariableStored("HBLevel")) {
            this._level = Integer.parseInt(GlobalVariablesManager.getInstance().getStoredVariable("HBLevel"));
            this._trust = Integer.parseInt(GlobalVariablesManager.getInstance().getStoredVariable("HBTrust"));
        } else {
            this.saveData();
        }
    }

    public final void saveData() {
        GlobalVariablesManager.getInstance().storeVariable("HBLevel", String.valueOf(this._level));
        GlobalVariablesManager.getInstance().storeVariable("HBTrust", String.valueOf(this._trust));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadSpawns() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(LOAD_SPAWNS);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template != null) {
                    HellboundSpawn spawnDat = new HellboundSpawn(template);
                    spawnDat.setAmount(1);
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    spawnDat.setRespawnMinDelay(0);
                    spawnDat.setRespawnMaxDelay(0);
                    int respawnRandom = rset.getInt("respawn_random");
                    if (respawnRandom > 0) {
                        spawnDat.setRespawnMinDelay(Math.max(rset.getInt("respawn_delay") - respawnRandom, 1));
                        spawnDat.setRespawnMaxDelay(rset.getInt("respawn_delay") + respawnRandom);
                    }
                    spawnDat.setMinLvl(rset.getInt("min_hellbound_level"));
                    spawnDat.setMaxLvl(rset.getInt("max_hellbound_level"));
                    this._population.add(spawnDat);
                    SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    continue;
                }
                _log.warning("HellboundManager: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
        }
        catch (Exception e) {
            _log.warning("HellboundManager: problem while loading spawns: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.config("HellboundManager: Loaded " + this._population.size() + " npc spawn locations.");
    }

    public static final HellboundManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final HellboundManager _instance = new HellboundManager();

        private SingletonHolder() {
        }
    }

    public static final class HellboundSpawn
    extends L2Spawn {
        private int _respawnDelay;
        private int _minLvl;
        private int _maxLvl;

        public HellboundSpawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException, NoSuchMethodException {
            super(mobTemplate);
        }

        public final int getMinLvl() {
            return this._minLvl;
        }

        public final void setMinLvl(int lvl) {
            this._minLvl = lvl;
        }

        public final int getMaxLvl() {
            return this._maxLvl;
        }

        public final void setMaxLvl(int lvl) {
            this._maxLvl = lvl;
        }

        @Override
        public final void decreaseCount(L2Npc oldNpc) {
            if (this.getRespawnDelay() <= 0) {
                this.stopRespawn();
            } else if (this.getRespawnMaxDelay() > this.getRespawnMinDelay()) {
                this.setRespawnDelay(Rnd.get(this.getRespawnMinDelay(), this.getRespawnMaxDelay()));
            }
            super.decreaseCount(oldNpc);
        }

        @Override
        public void setRespawnDelay(int i) {
            this._respawnDelay = i * 1000;
            super.setRespawnDelay(i);
        }

        @Override
        public int getRespawnDelay() {
            return this._respawnDelay;
        }
    }
}

