/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.model.L2Transformation;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.logging.Logger;

public class TransformationManager {
    private static final Logger _log = Logger.getLogger(TransformationManager.class.getName());
    private TIntObjectHashMap<L2Transformation> _transformations = new TIntObjectHashMap();

    public static TransformationManager getInstance() {
        return SingletonHolder._instance;
    }

    private TransformationManager() {
    }

    public void report() {
        _log.info("Loaded: " + this._transformations.size() + " transformations.");
    }

    public boolean transformPlayer(int id, L2PcInstance player) {
        L2Transformation template = this.getTransformationById(id);
        if (template != null) {
            L2Transformation trans = template.createTransformationForPlayer(player);
            trans.start();
            return true;
        }
        return false;
    }

    public L2Transformation getTransformationById(int id) {
        return (L2Transformation)this._transformations.get(id);
    }

    public L2Transformation registerTransformation(L2Transformation transformation) {
        return (L2Transformation)this._transformations.put(transformation.getId(), (Object)transformation);
    }

    private static class SingletonHolder {
        protected static final TransformationManager _instance = new TransformationManager();

        private SingletonHolder() {
        }
    }
}

