/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager.games;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Lottery {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    protected static final Logger _log = Logger.getLogger(Lottery.class.getName());
    private static final String INSERT_LOTTERY = "INSERT INTO games(id, idnr, enddate, prize, newprize) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_PRICE = "UPDATE games SET prize=?, newprize=? WHERE id = 1 AND idnr = ?";
    private static final String UPDATE_LOTTERY = "UPDATE games SET finished=1, prize=?, newprize=?, number1=?, number2=?, prize1=?, prize2=?, prize3=? WHERE id=1 AND idnr=?";
    private static final String SELECT_LAST_LOTTERY = "SELECT idnr, prize, newprize, enddate, finished FROM games WHERE id = 1 ORDER BY idnr DESC LIMIT 1";
    private static final String SELECT_LOTTERY_ITEM = "SELECT enchant_level, custom_type2 FROM items WHERE item_id = 4442 AND custom_type1 = ?";
    private static final String SELECT_LOTTERY_TICKET = "SELECT number1, number2, prize1, prize2, prize3 FROM games WHERE id = 1 and idnr = ?";
    protected int _number = 1;
    protected long _prize = Config.ALT_LOTTERY_PRIZE;
    protected boolean _isSellingTickets = false;
    protected boolean _isStarted = false;
    protected long _enddate = System.currentTimeMillis();

    private Lottery() {
        if (Config.ALLOW_LOTTERY) {
            new startLottery().run();
        }
    }

    public static Lottery getInstance() {
        return SingletonHolder._instance;
    }

    public int getId() {
        return this._number;
    }

    public long getPrize() {
        return this._prize;
    }

    public long getEndDate() {
        return this._enddate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increasePrize(long count) {
        this._prize += count;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(UPDATE_PRICE);
            statement.setLong(1, this.getPrize());
            statement.setLong(2, this.getPrize());
            statement.setInt(3, this.getId());
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Lottery: Could not increase current lottery prize: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public boolean isSellableTickets() {
        return this._isSellingTickets;
    }

    public boolean isStarted() {
        return this._isStarted;
    }

    public int[] decodeNumbers(int enchant, int type2) {
        int[] res = new int[5];
        int num = type2 << 16 | enchant;
        int id = 0;
        int nr = 1;
        while (num != 0) {
            if ((num & 1) != 0) {
                res[id++] = nr;
            }
            num >>>= 1;
            ++nr;
        }
        return res;
    }

    public long[] checkTicket(L2ItemInstance item) {
        return this.checkTicket(item.getCustomType1(), item.getEnchantLevel(), item.getCustomType2());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] checkTicket(int id, int enchant, int type2) {
        long[] res = new long[]{0L, 0L};
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SELECT_LOTTERY_TICKET);
            statement.setInt(1, id);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                int curenchant = rset.getInt("number1") & enchant;
                int curtype2 = rset.getInt("number2") & type2;
                if (curenchant == 0 && curtype2 == 0) {
                    rset.close();
                    statement.close();
                    long[] lArray = res;
                    return lArray;
                }
                int count = Integer.bitCount(curtype2 << 16 | curenchant);
                switch (count) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        res[0] = 1L;
                        res[1] = rset.getLong("prize1");
                        break;
                    }
                    case 4: {
                        res[0] = 2L;
                        res[1] = rset.getLong("prize2");
                        break;
                    }
                    case 3: {
                        res[0] = 3L;
                        res[1] = rset.getLong("prize3");
                        break;
                    }
                    default: {
                        res[0] = 4L;
                        res[1] = 200L;
                    }
                }
                if (Config.DEBUG) {
                    _log.warning("count: " + count + ", id: " + id + ", enchant: " + enchant + ", type2: " + type2);
                }
            }
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "Lottery: Could not check lottery ticket #" + id + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return res;
    }

    private void shout(int npcString, String ... param) {
        for (L2Spawn s : SpawnTable.getInstance().getSpawnTable()) {
            if (s == null || s.getNpcid() < 30990 || s.getNpcid() > 30994) continue;
            L2Npc npc = s.getLastSpawn();
            NpcSay packet = new NpcSay(npc.getObjectId(), 1, npc.getNpcId(), npcString);
            for (String text : param) {
                packet.addStringParameter(text);
            }
            npc.broadcastPacket(packet);
        }
    }

    private static class SingletonHolder {
        protected static final Lottery _instance = new Lottery();

        private SingletonHolder() {
        }
    }

    private class finishLottery
    implements Runnable {
        protected finishLottery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PreparedStatement statement;
            Lottery.this._isStarted = false;
            if (Config.DEBUG) {
                _log.info("Lottery: Ending lottery #" + Lottery.this.getId() + ".");
            }
            Lottery.this.shout(1000283, new String[0]);
            int[] luckynums = new int[5];
            for (int i = 0; i < 5; ++i) {
                int luckynum;
                while (Util.contains(luckynums, luckynum = Rnd.get(1, 20))) {
                }
                luckynums[i] = luckynum;
            }
            Arrays.sort(luckynums);
            if (Config.DEBUG) {
                _log.info("Lottery: The lucky numbers are " + luckynums[0] + ", " + luckynums[1] + ", " + luckynums[2] + ", " + luckynums[3] + ", " + luckynums[4] + ".");
            }
            int enchant = 0;
            int type2 = 0;
            for (int i = 0; i < 5; ++i) {
                int num = luckynums[i];
                if (num <= 16) {
                    enchant |= 1 << num - 1;
                    continue;
                }
                type2 |= 1 << num - 16 - 1;
            }
            if (Config.DEBUG) {
                _log.info("Lottery: Encoded lucky numbers are " + enchant + ", " + type2);
            }
            int count1 = 0;
            int count2 = 0;
            int count3 = 0;
            int count4 = 0;
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement(Lottery.SELECT_LOTTERY_ITEM);
                statement.setInt(1, Lottery.this.getId());
                ResultSet rset = statement.executeQuery();
                while (rset.next()) {
                    int curenchant = rset.getInt("enchant_level") & enchant;
                    int curtype2 = rset.getInt("custom_type2") & type2;
                    if (curenchant == 0 && curtype2 == 0) continue;
                    int count = 0;
                    count = Integer.bitCount(curtype2 << 16 | curenchant);
                    if (count == 5) {
                        ++count1;
                        continue;
                    }
                    if (count == 4) {
                        ++count2;
                        continue;
                    }
                    if (count == 3) {
                        ++count3;
                        continue;
                    }
                    if (count <= 0) continue;
                    ++count4;
                }
                rset.close();
                statement.close();
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, "Lottery: Could restore lottery data: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            long prize4 = (long)count4 * Config.ALT_LOTTERY_2_AND_1_NUMBER_PRIZE;
            long prize1 = 0L;
            long prize2 = 0L;
            long prize3 = 0L;
            if (count1 > 0) {
                prize1 = (long)((float)(Lottery.this.getPrize() - prize4) * Config.ALT_LOTTERY_5_NUMBER_RATE / (float)count1);
            }
            if (count2 > 0) {
                prize2 = (long)((float)(Lottery.this.getPrize() - prize4) * Config.ALT_LOTTERY_4_NUMBER_RATE / (float)count2);
            }
            if (count3 > 0) {
                prize3 = (long)((float)(Lottery.this.getPrize() - prize4) * Config.ALT_LOTTERY_3_NUMBER_RATE / (float)count3);
            }
            if (Config.DEBUG) {
                _log.info("Lottery: " + count1 + " players with all FIVE numbers each win " + prize1 + ".");
                _log.info("Lottery: " + count2 + " players with FOUR numbers each win " + prize2 + ".");
                _log.info("Lottery: " + count3 + " players with THREE numbers each win " + prize3 + ".");
                _log.info("Lottery: " + count4 + " players with ONE or TWO numbers each win " + prize4 + ".");
            }
            long newprize = Lottery.this.getPrize() - (prize1 + prize2 + prize3 + prize4);
            if (Config.DEBUG) {
                _log.info("Lottery: Jackpot for next lottery is " + newprize + ".");
            }
            if (count1 > 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AMOUNT_FOR_WINNER_S1_IS_S2_ADENA_WE_HAVE_S3_PRIZE_WINNER);
                sm.addNumber(Lottery.this.getId());
                sm.addItemNumber(Lottery.this.getPrize());
                sm.addItemNumber(count1);
                Announcements.getInstance().announceToAll(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AMOUNT_FOR_LOTTERY_S1_IS_S2_ADENA_NO_WINNER);
                sm.addNumber(Lottery.this.getId());
                sm.addItemNumber(Lottery.this.getPrize());
                Announcements.getInstance().announceToAll(sm);
            }
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement(Lottery.UPDATE_LOTTERY);
                statement.setLong(1, Lottery.this.getPrize());
                statement.setLong(2, newprize);
                statement.setInt(3, enchant);
                statement.setInt(4, type2);
                statement.setLong(5, prize1);
                statement.setLong(6, prize2);
                statement.setLong(7, prize3);
                statement.setInt(8, Lottery.this.getId());
                statement.execute();
                statement.close();
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, "Lottery: Could not store finished lottery data: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
            class ShoutResult
            implements Runnable {
                final int number;
                final int[] luckynums;

                ShoutResult(int number, int[] luckynums) {
                    this.number = number;
                    this.luckynums = luckynums;
                }

                private int getId() {
                    return this.number;
                }

                @Override
                public void run() {
                    Lottery.this.shout(1000284, new String[]{String.valueOf(this.getId()), this.luckynums[0] + " " + this.luckynums[1] + " " + this.luckynums[2] + " " + this.luckynums[3] + " " + this.luckynums[4] + " "});
                }
            }
            ShoutResult run = new ShoutResult(Lottery.this.getId(), luckynums);
            ThreadPoolManager.getInstance().scheduleGeneral(run, 30000L);
            ThreadPoolManager.getInstance().scheduleGeneral(run, 60000L);
            ThreadPoolManager.getInstance().scheduleGeneral(run, 90000L);
            ThreadPoolManager.getInstance().scheduleGeneral(new startLottery(), 600000L);
            ++Lottery.this._number;
        }
    }

    private class stopSellingTickets
    implements Runnable {
        protected stopSellingTickets() {
        }

        @Override
        public void run() {
            Lottery.this._isSellingTickets = false;
            if (Config.DEBUG) {
                _log.info("Lottery: Stopping ticket sell for lottery #" + Lottery.this.getId() + ".");
            }
            Announcements.getInstance().announceToAll(SystemMessage.getSystemMessage(SystemMessageId.LOTTERY_TICKET_SALES_TEMP_SUSPENDED));
        }
    }

    private class startLottery
    implements Runnable {
        protected startLottery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PreparedStatement statement;
            Connection con;
            long NOW;
            block14: {
                NOW = System.currentTimeMillis();
                con = null;
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    statement = con.prepareStatement(Lottery.SELECT_LAST_LOTTERY);
                    ResultSet rset = statement.executeQuery();
                    if (!rset.next()) break block14;
                    Lottery.this._number = rset.getInt("idnr");
                    if (rset.getInt("finished") == 1) {
                        ++Lottery.this._number;
                        Lottery.this._prize = rset.getLong("newprize");
                        rset.close();
                        rset = null;
                        statement.close();
                        statement = null;
                        L2DatabaseFactory.close(con);
                        con = null;
                        break block14;
                    }
                    Lottery.this._prize = rset.getLong("prize");
                    Lottery.this._enddate = rset.getLong("enddate");
                    rset.close();
                    rset = null;
                    statement.close();
                    statement = null;
                    L2DatabaseFactory.close(con);
                    con = null;
                    Lottery.this._isStarted = true;
                    ThreadPoolManager.getInstance().scheduleGeneral(new finishLottery(), Lottery.this._enddate - NOW);
                    if (Lottery.this._enddate - 600000L - NOW > 0L) {
                        Lottery.this._isSellingTickets = true;
                        ThreadPoolManager.getInstance().scheduleGeneral(new stopSellingTickets(), Lottery.this._enddate - 600000L - NOW);
                    }
                    return;
                }
                catch (SQLException e) {
                    _log.log(Level.WARNING, "Lottery: Could not restore lottery data: " + e.getMessage(), e);
                }
                finally {
                    L2DatabaseFactory.close(con);
                }
            }
            if (Config.DEBUG) {
                _log.info("Lottery: Starting ticket sell for lottery #" + Lottery.this.getId() + ".");
            }
            Lottery.this._isSellingTickets = true;
            Lottery.this._isStarted = true;
            Lottery.this.shout(1000282, new String[0]);
            Calendar finishtime = Calendar.getInstance();
            finishtime.set(14, 0);
            finishtime.set(13, 0);
            finishtime.set(12, 0);
            finishtime.set(11, 19);
            finishtime.set(7, 7);
            while ((Lottery.this._enddate = finishtime.getTimeInMillis()) <= NOW) {
                finishtime.add(5, 7);
            }
            ThreadPoolManager.getInstance().scheduleGeneral(new stopSellingTickets(), Lottery.this._enddate - 600000L - NOW);
            ThreadPoolManager.getInstance().scheduleGeneral(new finishLottery(), Lottery.this._enddate - NOW);
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement(Lottery.INSERT_LOTTERY);
                statement.setInt(1, 1);
                statement.setInt(2, Lottery.this.getId());
                statement.setLong(3, Lottery.this.getEndDate());
                statement.setLong(4, Lottery.this.getPrize());
                statement.setLong(5, Lottery.this.getPrize());
                statement.execute();
                statement.close();
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, "Lottery: Could not store new lottery data: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }
}

