/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.EnchantItem;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;

public class EnchantScroll
extends EnchantItem {
    private final boolean _isBlessed;
    private final boolean _isCrystal;
    private final boolean _isSafe;

    public EnchantScroll(boolean wep, boolean bless, boolean crystal, boolean safe, int type, int level, double chance, int[] items) {
        super(wep, type, level, chance, items);
        this._isBlessed = bless;
        this._isCrystal = crystal;
        this._isSafe = safe;
    }

    public final boolean isBlessed() {
        return this._isBlessed;
    }

    public final boolean isCrystal() {
        return this._isCrystal;
    }

    public final boolean isSafe() {
        return this._isSafe;
    }

    public final boolean isValid(L2ItemInstance enchantItem, EnchantItem supportItem) {
        if (supportItem != null && (!supportItem.isValid(enchantItem) || this.isBlessed())) {
            return false;
        }
        return super.isValid(enchantItem);
    }

    public final double getChance(L2ItemInstance enchantItem, EnchantItem supportItem) {
        boolean fullBody;
        if (!this.isValid(enchantItem, supportItem)) {
            return -1.0;
        }
        boolean bl = fullBody = enchantItem.getItem().getBodyPart() == 32768;
        if (enchantItem.getEnchantLevel() < Config.ENCHANT_SAFE_MAX || fullBody && enchantItem.getEnchantLevel() < Config.ENCHANT_SAFE_MAX_FULL) {
            return 100.0;
        }
        double chance = this._chanceAdd;
        if (supportItem != null && !this._isBlessed) {
            chance *= supportItem.getChanceAdd();
        }
        return chance;
    }
}

