/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.L2RecipeInstance;
import com.l2jserver.gameserver.model.L2RecipeStatInstance;
import com.l2jserver.gameserver.model.StatsSet;

public class L2RecipeList {
    private L2RecipeInstance[] _recipes = new L2RecipeInstance[0];
    private L2RecipeStatInstance[] _statUse = new L2RecipeStatInstance[0];
    private L2RecipeStatInstance[] _altStatChange = new L2RecipeStatInstance[0];
    private int _id;
    private int _level;
    private int _recipeId;
    private String _recipeName;
    private int _successRate;
    private int _itemId;
    private int _count;
    private int _rareItemId;
    private int _rareCount;
    private int _rarity;
    private boolean _isDwarvenRecipe;

    public L2RecipeList(StatsSet set, boolean haveRare) {
        this._id = set.getInteger("id");
        this._level = set.getInteger("craftLevel");
        this._recipeId = set.getInteger("recipeId");
        this._recipeName = set.getString("recipeName");
        this._successRate = set.getInteger("successRate");
        this._itemId = set.getInteger("itemId");
        this._count = set.getInteger("count");
        if (haveRare) {
            this._rareItemId = set.getInteger("rareItemId");
            this._rareCount = set.getInteger("rareCount");
            this._rarity = set.getInteger("rarity");
        }
        this._isDwarvenRecipe = set.getBool("isDwarvenRecipe");
    }

    public void addRecipe(L2RecipeInstance recipe) {
        int len = this._recipes.length;
        L2RecipeInstance[] tmp = new L2RecipeInstance[len + 1];
        System.arraycopy(this._recipes, 0, tmp, 0, len);
        tmp[len] = recipe;
        this._recipes = tmp;
    }

    public void addStatUse(L2RecipeStatInstance statUse) {
        int len = this._statUse.length;
        L2RecipeStatInstance[] tmp = new L2RecipeStatInstance[len + 1];
        System.arraycopy(this._statUse, 0, tmp, 0, len);
        tmp[len] = statUse;
        this._statUse = tmp;
    }

    public void addAltStatChange(L2RecipeStatInstance statChange) {
        int len = this._altStatChange.length;
        L2RecipeStatInstance[] tmp = new L2RecipeStatInstance[len + 1];
        System.arraycopy(this._altStatChange, 0, tmp, 0, len);
        tmp[len] = statChange;
        this._altStatChange = tmp;
    }

    public int getId() {
        return this._id;
    }

    public int getLevel() {
        return this._level;
    }

    public int getRecipeId() {
        return this._recipeId;
    }

    public String getRecipeName() {
        return this._recipeName;
    }

    public int getSuccessRate() {
        return this._successRate;
    }

    public boolean isConsumable() {
        return this._itemId >= 1463 && this._itemId <= 1467 || this._itemId >= 2509 && this._itemId <= 2514 || this._itemId >= 3947 && this._itemId <= 3952 || this._itemId >= 1341 && this._itemId <= 1345;
    }

    public int getItemId() {
        return this._itemId;
    }

    public int getCount() {
        return this._count;
    }

    public int getRareItemId() {
        return this._rareItemId;
    }

    public int getRareCount() {
        return this._rareCount;
    }

    public int getRarity() {
        return this._rarity;
    }

    public boolean isDwarvenRecipe() {
        return this._isDwarvenRecipe;
    }

    public L2RecipeInstance[] getRecipes() {
        return this._recipes;
    }

    public L2RecipeStatInstance[] getStatUse() {
        return this._statUse;
    }

    public L2RecipeStatInstance[] getAltStatChange() {
        return this._altStatChange;
    }
}

