/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.Race;
import java.util.logging.Logger;

public final class L2SkillLearn {
    private static final Logger _log = Logger.getLogger(L2SkillLearn.class.getName());
    private final String _skillName;
    private final int _skillId;
    private final int _skillLvl;
    private final int _getLevel;
    private final boolean _autoGet;
    private final int _levelUpSp;
    private final int[][] _itemsIdCount;
    private final Race[] _races;
    private final int[] _preReqSkillIdLvl;
    private final int _socialClass;
    private final boolean _residenceSkill;
    private final int[] _residenceIds;
    private final int[][] _subClassLvlNumber;
    private final boolean _learnedByNpc;
    private final boolean _learnedByFS;

    public L2SkillLearn(StatsSet set) {
        int i;
        this._skillName = set.getString("skillName");
        this._skillId = set.getInteger("skillId");
        this._skillLvl = set.getInteger("skillLvl");
        this._getLevel = set.getInteger("getLevel");
        this._autoGet = set.getBool("autoGet", false);
        this._levelUpSp = set.getInteger("levelUpSp", 0);
        if (!set.getString("itemsIdCount", "").isEmpty()) {
            String[] items = set.getString("itemsIdCount").split(";");
            this._itemsIdCount = new int[items.length][2];
            i = 0;
            for (String itemIdCount : items) {
                try {
                    this._itemsIdCount[i][0] = Integer.parseInt(itemIdCount.split(",")[0]);
                    this._itemsIdCount[i][1] = Integer.parseInt(itemIdCount.split(",")[1]);
                    ++i;
                }
                catch (Exception e) {
                    _log.severe(this.getClass().getSimpleName() + ": Malformed itemsIdCount for Learn Skill Id " + this._skillId + " and level " + this._skillLvl + "!");
                }
            }
        } else {
            this._itemsIdCount = null;
        }
        if (!set.getString("race", "").isEmpty()) {
            int[] allowedRaces = set.getIntegerArray("race");
            int totalRaces = allowedRaces.length;
            this._races = new Race[totalRaces];
            for (int i2 = 0; i2 < totalRaces; ++i2) {
                this._races[i2] = Race.values()[allowedRaces[i2]];
            }
        } else {
            this._races = null;
        }
        if (!set.getString("preReqSkillIdLvl", "").isEmpty()) {
            this._preReqSkillIdLvl = new int[2];
            try {
                this._preReqSkillIdLvl[0] = Integer.parseInt(set.getString("preReqSkillIdLvl").split(",")[0]);
                this._preReqSkillIdLvl[1] = Integer.parseInt(set.getString("preReqSkillIdLvl").split(",")[1]);
            }
            catch (Exception e) {
                _log.severe(this.getClass().getSimpleName() + ": Malformed preReqSkillIdLvl for Learn Skill Id " + this._skillId + " and level " + this._skillLvl + "!");
            }
        } else {
            this._preReqSkillIdLvl = null;
        }
        this._socialClass = set.getInteger("socialClass", 0);
        this._residenceSkill = set.getBool("residenceSkill", false);
        this._residenceIds = (int[])(!set.getString("residenceIds", "").isEmpty() ? set.getIntegerArray("residenceIds") : null);
        if (!set.getString("subClassLvlNumber", "").isEmpty()) {
            String[] subLvLNumList = set.getString("subClassLvlNumber").split(";");
            this._subClassLvlNumber = new int[subLvLNumList.length][2];
            i = 0;
            for (String subLvlNum : subLvLNumList) {
                try {
                    this._subClassLvlNumber[i][0] = Integer.parseInt(subLvlNum.split(",")[0]);
                    this._subClassLvlNumber[i][1] = Integer.parseInt(subLvlNum.split(",")[1]);
                    ++i;
                }
                catch (Exception e) {
                    _log.severe(this.getClass().getSimpleName() + ": Malformed subClassLvlNumber for Learn Skill Id " + this._skillId + " and level " + this._skillLvl + "!");
                }
            }
        } else {
            this._subClassLvlNumber = null;
        }
        this._learnedByNpc = set.getBool("learnedByNpc", false);
        this._learnedByFS = set.getBool("learnedByFS", false);
    }

    public String getName() {
        return this._skillName;
    }

    public int getSkillId() {
        return this._skillId;
    }

    public int getSkillLevel() {
        return this._skillLvl;
    }

    public int getGetLevel() {
        return this._getLevel;
    }

    public int getLevelUpSp() {
        return this._levelUpSp;
    }

    public boolean isAutoGet() {
        return this._autoGet;
    }

    public int[][] getItemsIdCount() {
        return this._itemsIdCount;
    }

    public Race[] getRaces() {
        return this._races;
    }

    public int[] getPreReqSkillIdLvl() {
        return this._preReqSkillIdLvl;
    }

    public int getSocialClass() {
        return this._socialClass;
    }

    public boolean isResidencialSkill() {
        return this._residenceSkill;
    }

    public int[] getRecidenceIds() {
        return this._residenceIds;
    }

    public int[][] getSubClassConditions() {
        return this._subClassLvlNumber;
    }

    public boolean isLearnedByNpc() {
        return this._learnedByNpc;
    }

    public boolean isLearnedByFS() {
        return this._learnedByFS;
    }

    public int getCalculatedLevelUpSp(ClassId playerClass, ClassId learningClass) {
        if (playerClass == null || learningClass == null) {
            return this._levelUpSp;
        }
        int levelUpSp = this._levelUpSp;
        if (Config.ALT_GAME_SKILL_LEARN && playerClass != learningClass) {
            levelUpSp = playerClass.isMage() != learningClass.isMage() ? (levelUpSp *= 3) : (levelUpSp *= 2);
        }
        return levelUpSp;
    }
}

