/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.item.type.L2EtcItemType;
import com.l2jserver.gameserver.network.serverpackets.ExAutoSoulShot;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.ShortCutRegister;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShortCuts {
    private static Logger _log = Logger.getLogger(ShortCuts.class.getName());
    private static final int MAX_SHORTCUTS_PER_BAR = 12;
    private final L2PcInstance _owner;
    private final Map<Integer, L2ShortCut> _shortCuts = new TreeMap<Integer, L2ShortCut>();

    public ShortCuts(L2PcInstance owner) {
        this._owner = owner;
    }

    public L2ShortCut[] getAllShortCuts() {
        return this._shortCuts.values().toArray(new L2ShortCut[this._shortCuts.values().size()]);
    }

    public L2ShortCut getShortCut(int slot, int page) {
        L2ShortCut sc = this._shortCuts.get(slot + page * 12);
        if (sc != null && sc.getType() == 1 && this._owner.getInventory().getItemByObjectId(sc.getId()) == null) {
            this.deleteShortCut(sc.getSlot(), sc.getPage());
            sc = null;
        }
        return sc;
    }

    public synchronized void registerShortCut(L2ShortCut shortcut) {
        if (shortcut.getType() == 1) {
            L2ItemInstance item = this._owner.getInventory().getItemByObjectId(shortcut.getId());
            if (item == null) {
                return;
            }
            if (item.isEtcItem()) {
                shortcut.setSharedReuseGroup(item.getEtcItem().getSharedReuseGroup());
            }
        }
        L2ShortCut oldShortCut = this._shortCuts.put(shortcut.getSlot() + shortcut.getPage() * 12, shortcut);
        this.registerShortCutInDb(shortcut, oldShortCut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerShortCutInDb(L2ShortCut shortcut, L2ShortCut oldShortCut) {
        if (oldShortCut != null) {
            this.deleteShortCutFromDb(oldShortCut);
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("REPLACE INTO character_shortcuts (charId,slot,page,type,shortcut_id,level,class_index) values(?,?,?,?,?,?,?)");
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, shortcut.getSlot());
            statement.setInt(3, shortcut.getPage());
            statement.setInt(4, shortcut.getType());
            statement.setInt(5, shortcut.getId());
            statement.setInt(6, shortcut.getLevel());
            statement.setInt(7, this._owner.getClassIndex());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store character shortcut: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public synchronized void deleteShortCut(int slot, int page) {
        L2ItemInstance item;
        L2ShortCut old = this._shortCuts.remove(slot + page * 12);
        if (old == null || this._owner == null) {
            return;
        }
        this.deleteShortCutFromDb(old);
        if (old.getType() == 1 && (item = this._owner.getInventory().getItemByObjectId(old.getId())) != null && item.getItemType() == L2EtcItemType.SHOT && this._owner.removeAutoSoulShot(item.getItemId())) {
            this._owner.sendPacket(new ExAutoSoulShot(item.getItemId(), 0));
        }
        this._owner.sendPacket(new ShortCutInit(this._owner));
        for (int shotId : this._owner.getAutoSoulShot()) {
            this._owner.sendPacket(new ExAutoSoulShot(shotId, 1));
        }
    }

    public synchronized void deleteShortCutByObjectId(int objectId) {
        for (L2ShortCut shortcut : this._shortCuts.values()) {
            if (shortcut.getType() != 1 || shortcut.getId() != objectId) continue;
            this.deleteShortCut(shortcut.getSlot(), shortcut.getPage());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteShortCutFromDb(L2ShortCut shortcut) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE charId=? AND slot=? AND page=? AND class_index=?");
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, shortcut.getSlot());
            statement.setInt(3, shortcut.getPage());
            statement.setInt(4, this._owner.getClassIndex());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not delete character shortcut: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this._shortCuts.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT charId, slot, page, type, shortcut_id, level FROM character_shortcuts WHERE charId=? AND class_index=?");
            statement.setInt(1, this._owner.getObjectId());
            statement.setInt(2, this._owner.getClassIndex());
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int slot = rset.getInt("slot");
                int page = rset.getInt("page");
                int type = rset.getInt("type");
                int id = rset.getInt("shortcut_id");
                int level = rset.getInt("level");
                L2ShortCut sc = new L2ShortCut(slot, page, type, id, level, 1);
                this._shortCuts.put(slot + page * 12, sc);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore character shortcuts: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        for (L2ShortCut sc : this.getAllShortCuts()) {
            if (sc.getType() != 1) continue;
            L2ItemInstance item = this._owner.getInventory().getItemByObjectId(sc.getId());
            if (item == null) {
                this.deleteShortCut(sc.getSlot(), sc.getPage());
                continue;
            }
            if (!item.isEtcItem()) continue;
            sc.setSharedReuseGroup(item.getEtcItem().getSharedReuseGroup());
        }
    }

    public synchronized void updateShortCuts(int skillId, int skillLevel) {
        for (L2ShortCut sc : this._shortCuts.values()) {
            if (sc.getId() != skillId || sc.getType() != 2) continue;
            L2ShortCut newsc = new L2ShortCut(sc.getSlot(), sc.getPage(), sc.getType(), sc.getId(), skillLevel, 1);
            this._owner.sendPacket(new ShortCutRegister(newsc));
            this._owner.registerShortCut(newsc);
        }
    }
}

