/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.status;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.status.SummonStatus;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class PetStatus
extends SummonStatus {
    private int _currentFed = 0;

    public PetStatus(L2PetInstance activeChar) {
        super(activeChar);
    }

    @Override
    public final void reduceHp(double value, L2Character attacker) {
        this.reduceHp(value, attacker, true, false, false);
    }

    @Override
    public final void reduceHp(double value, L2Character attacker, boolean awake, boolean isDOT, boolean isHpConsumption) {
        if (this.getActiveChar().isDead()) {
            return;
        }
        super.reduceHp(value, attacker, awake, isDOT, isHpConsumption);
        if (attacker != null) {
            if (!isDOT && this.getActiveChar().getOwner() != null) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_RECEIVED_S2_DAMAGE_BY_C1);
                sm.addCharName(attacker);
                sm.addNumber((int)value);
                this.getActiveChar().sendPacket(sm);
            }
            this.getActiveChar().getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, attacker);
        }
    }

    public int getCurrentFed() {
        return this._currentFed;
    }

    public void setCurrentFed(int value) {
        this._currentFed = value;
    }

    @Override
    public L2PetInstance getActiveChar() {
        return (L2PetInstance)super.getActiveChar();
    }
}

