/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.status;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.status.PlayableStatus;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.util.Util;

public class SummonStatus
extends PlayableStatus {
    public SummonStatus(L2Summon activeChar) {
        super(activeChar);
    }

    @Override
    public void reduceHp(double value, L2Character attacker) {
        this.reduceHp(value, attacker, true, false, false);
    }

    @Override
    public void reduceHp(double value, L2Character attacker, boolean awake, boolean isDOT, boolean isHPConsumption) {
        L2PcInstance caster;
        if (attacker == null || this.getActiveChar().isDead()) {
            return;
        }
        L2PcInstance attackerPlayer = attacker.getActingPlayer();
        if (attackerPlayer != null && (this.getActiveChar().getOwner() == null || this.getActiveChar().getOwner().getDuelId() != attackerPlayer.getDuelId())) {
            attackerPlayer.setDuelState(4);
        }
        if (this.getActiveChar().getOwner().getParty() != null && (caster = this.getActiveChar().getTransferingDamageTo()) != null && this.getActiveChar().getParty() != null && Util.checkIfInRange(1000, this.getActiveChar(), caster, true) && !caster.isDead() && this.getActiveChar().getOwner() != caster && this.getActiveChar().getParty().getPartyMembers().contains((Object)caster)) {
            int transferDmg = 0;
            transferDmg = (int)value * (int)this.getActiveChar().getStat().calcStat(Stats.TRANSFER_DAMAGE_TO_PLAYER, 0.0, null, null) / 100;
            transferDmg = Math.min((int)caster.getCurrentHp() - 1, transferDmg);
            if (transferDmg > 0 && attacker instanceof L2Playable) {
                int membersInRange = 0;
                for (L2PcInstance member : caster.getParty().getPartyMembers()) {
                    if (!Util.checkIfInRange(1000, member, caster, false) || member == caster) continue;
                    ++membersInRange;
                }
                if (caster.getCurrentCp() > 0.0) {
                    if (caster.getCurrentCp() > (double)transferDmg) {
                        this.reduceCp(transferDmg);
                    } else {
                        transferDmg = (int)((double)transferDmg - caster.getCurrentCp());
                        this.reduceCp((int)caster.getCurrentCp());
                    }
                }
                caster.reduceCurrentHp(transferDmg / membersInRange, attacker, null);
                value -= (double)transferDmg;
            }
        }
        super.reduceHp(value, attacker, awake, isDOT, isHPConsumption);
    }

    @Override
    public L2Summon getActiveChar() {
        return (L2Summon)super.getActiveChar();
    }
}

