/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity.clanhall;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.ClanHallSiegeEngine;
import com.l2jserver.gameserver.model.entity.clanhall.SiegeStatus;
import com.l2jserver.gameserver.model.zone.type.L2SiegableHallZone;
import com.l2jserver.gameserver.model.zone.type.L2SiegeZone;
import com.l2jserver.gameserver.network.serverpackets.SiegeInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javolution.util.FastList;

public final class SiegableHall
extends ClanHall {
    private static final String SQL_SAVE = "UPDATE siegable_clanhall SET ownerId=?, nextSiege=? WHERE clanHallId=?";
    protected List<String> _doorDefault;
    private Calendar _nextSiege;
    private long _siegeLength;
    private int[] _scheduleConfig = new int[]{7, 0, 0, 12, 0};
    private SiegeStatus _status = SiegeStatus.REGISTERING;
    private L2SiegeZone _siegeZone;
    private ClanHallSiegeEngine _siege;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public SiegableHall(StatsSet set) {
        super(set);
        this._doorDefault = new FastList();
        this._siegeLength = set.getLong("siegeLenght");
        String[] rawSchConfig = set.getString("scheduleConfig").split(";");
        if (rawSchConfig.length == 5) {
            for (int i = 0; i < 5; ++i) {
                try {
                    this._scheduleConfig[i] = Integer.parseInt(rawSchConfig[i]);
                    continue;
                }
                catch (Exception e) {
                    _log.warning("SiegableHall - " + this.getName() + ": Wrong schedule_config parameters!");
                }
            }
        } else {
            _log.warning(this.getName() + ": Wrong schedule_config value in siegable_halls table, using default (7 days)");
        }
        this._nextSiege = Calendar.getInstance();
        long nextSiege = set.getLong("nextSiege");
        if (nextSiege - System.currentTimeMillis() < 0L) {
            this.updateNextSiege();
        } else {
            this._nextSiege.setTimeInMillis(nextSiege);
        }
    }

    public List<String> getDoorDefault() {
        return this._doorDefault;
    }

    public void spawnDoor() {
        this.spawnDoor(false);
    }

    public void spawnDoor(boolean isDoorWeak) {
        for (int i = 0; i < this.getDoors().size(); ++i) {
            L2DoorInstance door = this.getDoors().get(i);
            if (door.getCurrentHp() <= 0.0) {
                door.decayMe();
                door = DoorTable.parseList(this._doorDefault.get(i), false);
                DoorTable.getInstance().putDoor(door);
                if (isDoorWeak) {
                    door.setCurrentHp(door.getMaxHp() / 2);
                }
                door.spawnMe(door.getX(), door.getY(), door.getZ());
                this.getDoors().set(i, door);
                continue;
            }
            if (!door.getOpen()) continue;
            door.closeMe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateDb() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SQL_SAVE);
            statement.setInt(1, this.getOwnerId());
            statement.setLong(2, this.getNextSiegeTime());
            statement.setInt(3, this.getId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: SiegableHall.updateDb(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final void setSiege(ClanHallSiegeEngine siegable) {
        this._siege = siegable;
        this._siegeZone.setSiegeInstance(siegable);
    }

    public final ClanHallSiegeEngine getSiege() {
        return this._siege;
    }

    public final Calendar getSiegeDate() {
        return this._nextSiege;
    }

    public static String dateFormat(long d) {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date(d));
    }

    public static String dateFormat(Date d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d);
    }

    public static String dateFormat(Calendar d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d.getTime());
    }

    public final long getNextSiegeTime() {
        return this._nextSiege.getTimeInMillis();
    }

    public long getSiegeLenght() {
        return this._siegeLength;
    }

    public final void setNextSiegeDate(long date) {
        this._nextSiege.setTimeInMillis(date);
    }

    public final void setNextSiegeDate(Calendar c) {
        this._nextSiege = c;
    }

    public final void updateNextSiege() {
        Calendar c = Calendar.getInstance();
        c.add(6, this._scheduleConfig[0]);
        c.add(2, this._scheduleConfig[1]);
        c.add(1, this._scheduleConfig[2]);
        c.set(11, this._scheduleConfig[3]);
        c.set(12, this._scheduleConfig[4]);
        c.set(13, 0);
        this.setNextSiegeDate(c);
        this.updateDb();
    }

    public final void addAttacker(L2Clan clan) {
        if (this.getSiege() != null) {
            this.getSiege().getAttackers().put((Object)clan.getClanId(), (Object)new L2SiegeClan(clan.getClanId(), L2SiegeClan.SiegeClanType.ATTACKER));
        }
    }

    public final void removeAttacker(L2Clan clan) {
        if (this.getSiege() != null) {
            this.getSiege().getAttackers().remove((Object)clan.getClanId());
        }
    }

    public final boolean isRegistered(L2Clan clan) {
        if (this.getSiege() == null) {
            return false;
        }
        return this.getSiege().checkIsAttacker(clan);
    }

    public SiegeStatus getSiegeStatus() {
        return this._status;
    }

    public final boolean isRegistering() {
        return this._status == SiegeStatus.REGISTERING;
    }

    public final boolean isInSiege() {
        return this._status == SiegeStatus.RUNNING;
    }

    public final boolean isWaitingBattle() {
        return this._status == SiegeStatus.WAITING_BATTLE;
    }

    public final void updateSiegeStatus(SiegeStatus status) {
        this._status = status;
    }

    public final L2SiegeZone getSiegeZone() {
        return this._siegeZone;
    }

    public final void setSiegeZone(L2SiegeZone zone) {
        this._siegeZone = zone;
    }

    public final void updateSiegeZone(boolean active) {
        this._siegeZone.setIsActive(active);
    }

    public final void showSiegeInfo(L2PcInstance player) {
        player.sendPacket(new SiegeInfo(this));
    }

    @Override
    public final boolean isSiegableHall() {
        return true;
    }

    @Override
    public L2SiegableHallZone getZone() {
        return (L2SiegableHallZone)super.getZone();
    }
}

