/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemauction;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;

public final class AuctionItem {
    private final int _auctionItemId;
    private final int _auctionLength;
    private final long _auctionInitBid;
    private final int _itemId;
    private final long _itemCount;
    private final StatsSet _itemExtra;

    public AuctionItem(int auctionItemId, int auctionLength, long auctionInitBid, int itemId, long itemCount, StatsSet itemExtra) {
        this._auctionItemId = auctionItemId;
        this._auctionLength = auctionLength;
        this._auctionInitBid = auctionInitBid;
        this._itemId = itemId;
        this._itemCount = itemCount;
        this._itemExtra = itemExtra;
    }

    public final boolean checkItemExists() {
        L2Item item = ItemTable.getInstance().getTemplate(this._itemId);
        return item != null;
    }

    public final int getAuctionItemId() {
        return this._auctionItemId;
    }

    public final int getAuctionLength() {
        return this._auctionLength;
    }

    public final long getAuctionInitBid() {
        return this._auctionInitBid;
    }

    public final int getItemId() {
        return this._itemId;
    }

    public final long getItemCount() {
        return this._itemCount;
    }

    public final L2ItemInstance createNewItemInstance() {
        L2ItemInstance item = ItemTable.getInstance().createItem("ItemAuction", this._itemId, this._itemCount, null, null);
        int enchantLevel = this._itemExtra.getInteger("enchant_level", 0);
        item.setEnchantLevel(enchantLevel);
        int augmentationId = this._itemExtra.getInteger("augmentation_id", 0);
        if (augmentationId != 0) {
            int augmentationSkillId = this._itemExtra.getInteger("augmentation_skill_id", 0);
            int augmentationSkillLevel = this._itemExtra.getInteger("augmentation_skill_lvl", 0);
            item.setAugmentation(new L2Augmentation(augmentationId, augmentationSkillId, augmentationSkillLevel));
        }
        return item;
    }
}

