/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.skills.Stats;
import java.util.concurrent.Future;

public class L2DamageZone
extends L2ZoneType {
    private int _damageHPPerSec = 200;
    private int _damageMPPerSec = 0;
    private Future<?> _task;
    private int _castleId = 0;
    private Castle _castle = null;
    private int _startTask = 10;
    private int _reuseTask = 5000;
    private boolean _enabled = true;

    public L2DamageZone(int id) {
        super(id);
        this.setTargetType(L2Object.InstanceType.L2Playable);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("dmgHPSec")) {
            this._damageHPPerSec = Integer.parseInt(value);
        } else if (name.equals("dmgMPSec")) {
            this._damageMPPerSec = Integer.parseInt(value);
        } else if (name.equals("castleId")) {
            this._castleId = Integer.parseInt(value);
        } else if (name.equalsIgnoreCase("initialDelay")) {
            this._startTask = Integer.parseInt(value);
        } else if (name.equalsIgnoreCase("reuse")) {
            this._reuseTask = Integer.parseInt(value);
        } else if (name.equalsIgnoreCase("default_enabled")) {
            this._enabled = Boolean.parseBoolean(value);
        } else {
            super.setParameter(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEnter(L2Character character) {
        if (this._task == null && (this._damageHPPerSec != 0 || this._damageMPPerSec != 0)) {
            L2PcInstance player = character.getActingPlayer();
            if (!(this.getCastle() == null || this.getCastle().getSiege().getIsInProgress() && player != null && player.getSiegeState() != 2)) {
                return;
            }
            L2DamageZone l2DamageZone = this;
            synchronized (l2DamageZone) {
                if (this._task == null) {
                    this._task = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ApplyDamage(this), this._startTask, this._reuseTask);
                }
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (this._characterList.isEmpty() && this._task != null) {
            this.stopTask();
        }
    }

    protected int getHPDamagePerSecond() {
        return this._damageHPPerSec;
    }

    protected int getMPDamagePerSecond() {
        return this._damageMPPerSec;
    }

    protected void stopTask() {
        if (this._task != null) {
            this._task.cancel(false);
            this._task = null;
        }
    }

    private Castle getCastle() {
        if (this._castleId > 0 && this._castle == null) {
            this._castle = CastleManager.getInstance().getCastleById(this._castleId);
        }
        return this._castle;
    }

    public void setEnabled(boolean state) {
        this._enabled = state;
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    class ApplyDamage
    implements Runnable {
        private final L2DamageZone _dmgZone;
        private final Castle _castle;

        ApplyDamage(L2DamageZone zone) {
            this._dmgZone = zone;
            this._castle = zone.getCastle();
        }

        @Override
        public void run() {
            boolean siege = false;
            if (this._castle != null && !(siege = this._castle.getSiege().getIsInProgress())) {
                this._dmgZone.stopTask();
                return;
            }
            if (!L2DamageZone.this._enabled) {
                return;
            }
            for (L2Character temp : this._dmgZone.getCharactersInsideArray()) {
                L2PcInstance player;
                if (temp == null || temp.isDead() || siege && (player = temp.getActingPlayer()) != null && player.isInSiege() && player.getSiegeState() == 2) continue;
                double multiplier = 1.0 + temp.calcStat(Stats.DAMAGE_ZONE_VULN, 0.0, null, null) / 100.0;
                if (L2DamageZone.this.getHPDamagePerSecond() != 0) {
                    temp.reduceCurrentHp((double)this._dmgZone.getHPDamagePerSecond() * multiplier, null, null);
                }
                if (L2DamageZone.this.getMPDamagePerSecond() == 0) continue;
                temp.reduceCurrentMp((double)this._dmgZone.getMPDamagePerSecond() * multiplier);
            }
        }
    }
}

