/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;

public class L2NoRestartZone
extends L2ZoneType {
    private int _restartAllowedTime = 0;
    private boolean _enabled = true;

    public L2NoRestartZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equalsIgnoreCase("default_enabled")) {
            this._enabled = Boolean.parseBoolean(value);
        } else if (name.equalsIgnoreCase("restartAllowedTime")) {
            this._restartAllowedTime = Integer.parseInt(value);
        } else if (!name.equalsIgnoreCase("restartTime") && !name.equalsIgnoreCase("instanceId")) {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (!this._enabled) {
            return;
        }
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)22, true);
            L2PcInstance player = (L2PcInstance)character;
            if (player.getZoneRestartLimitTime() > 0L && player.getZoneRestartLimitTime() < System.currentTimeMillis()) {
                ThreadPoolManager.getInstance().scheduleGeneral(new TeleportTask(player), 2000L);
            }
            player.setZoneRestartLimitTime(0L);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (!this._enabled) {
            return;
        }
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)22, false);
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public int getRestartAllowedTime() {
        return this._restartAllowedTime;
    }

    public void setRestartAllowedTime(int time) {
        this._restartAllowedTime = time;
    }

    private static class TeleportTask
    implements Runnable {
        private final L2PcInstance _player;

        public TeleportTask(L2PcInstance player) {
            this._player = player;
        }

        @Override
        public void run() {
            this._player.teleToLocation(MapRegionManager.TeleportWhereType.Town);
        }
    }
}

