/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2OlympiadManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMatchEnd;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;

public class L2OlympiadStadiumZone
extends L2ZoneRespawn {
    private final List<L2Spawn> _buffers = new ArrayList<L2Spawn>(2);
    OlympiadGameTask _task = null;

    public L2OlympiadStadiumZone(int id) {
        super(id);
    }

    public final void registerTask(OlympiadGameTask task) {
        this._task = task;
    }

    public final void openDoors() {
        for (L2DoorInstance door : InstanceManager.getInstance().getInstance(this.getInstanceId()).getDoors()) {
            if (door == null || door.getOpen()) continue;
            door.openMe();
        }
    }

    public final void closeDoors() {
        for (L2DoorInstance door : InstanceManager.getInstance().getInstance(this.getInstanceId()).getDoors()) {
            if (door == null || !door.getOpen()) continue;
            door.closeMe();
        }
    }

    public final void spawnBuffers() {
        for (L2Spawn spawn : this._buffers) {
            spawn.startRespawn();
            spawn.respawnNpc(spawn.getLastSpawn());
            spawn.stopRespawn();
        }
    }

    public final void deleteBuffers() {
        for (L2Spawn spawn : this._buffers) {
            if (!spawn.getLastSpawn().isVisible()) continue;
            spawn.getLastSpawn().deleteMe();
        }
    }

    public final void broadcastStatusUpdate(L2PcInstance player) {
        ExOlympiadUserInfo packet = new ExOlympiadUserInfo(player);
        for (L2Character character : this.getCharactersInsideArray()) {
            if (!(character instanceof L2PcInstance) || !((L2PcInstance)character).inObserverMode() && ((L2PcInstance)character).getOlympiadSide() == player.getOlympiadSide()) continue;
            character.sendPacket(packet);
        }
    }

    public final void broadcastPacketToObservers(L2GameServerPacket packet) {
        for (L2Character character : this.getCharactersInsideArray()) {
            if (!(character instanceof L2PcInstance) || !((L2PcInstance)character).inObserverMode()) continue;
            character.sendPacket(packet);
        }
    }

    @Override
    protected final void onEnter(L2Character character) {
        L2Spawn spawn;
        character.setInsideZone((byte)12, true);
        if (this._task != null && this._task.isBattleStarted()) {
            character.setInsideZone((byte)0, true);
            if (character instanceof L2PcInstance) {
                character.sendPacket(SystemMessageId.ENTERED_COMBAT_ZONE);
                this._task.getGame().sendOlympiadInfo(character);
            }
        }
        if (character instanceof L2Playable) {
            L2PcInstance player = character.getActingPlayer();
            if (!(player == null || player.isGM() || player.isInOlympiadMode() || player.inObserverMode())) {
                ThreadPoolManager.getInstance().executeTask(new KickPlayer(player));
            }
        } else if (character instanceof L2OlympiadManagerInstance && (spawn = ((L2OlympiadManagerInstance)character).getSpawn()) != null && !this._buffers.contains(spawn)) {
            this._buffers.add(spawn);
            spawn.stopRespawn();
            character.deleteMe();
        }
    }

    @Override
    protected final void onExit(L2Character character) {
        character.setInsideZone((byte)12, false);
        if (this._task != null && this._task.isBattleStarted()) {
            character.setInsideZone((byte)0, false);
            if (character instanceof L2PcInstance) {
                character.sendPacket(SystemMessageId.LEFT_COMBAT_ZONE);
                character.sendPacket(ExOlympiadMatchEnd.STATIC_PACKET);
            }
        }
    }

    public final void updateZoneStatusForCharactersInside() {
        if (this._task == null) {
            return;
        }
        boolean battleStarted = this._task.isBattleStarted();
        SystemMessage sm = battleStarted ? SystemMessage.getSystemMessage(SystemMessageId.ENTERED_COMBAT_ZONE) : SystemMessage.getSystemMessage(SystemMessageId.LEFT_COMBAT_ZONE);
        for (L2Character character : this.getCharactersInsideArray()) {
            if (character == null) continue;
            if (battleStarted) {
                character.setInsideZone((byte)0, true);
                if (!(character instanceof L2PcInstance)) continue;
                character.sendPacket(sm);
                continue;
            }
            character.setInsideZone((byte)0, false);
            if (!(character instanceof L2PcInstance)) continue;
            character.sendPacket(sm);
            character.sendPacket(ExOlympiadMatchEnd.STATIC_PACKET);
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    private static final class KickPlayer
    implements Runnable {
        private L2PcInstance _player;

        public KickPlayer(L2PcInstance player) {
            this._player = player;
        }

        @Override
        public void run() {
            if (this._player != null) {
                L2Summon summon = this._player.getPet();
                if (summon != null) {
                    summon.unSummon(this._player);
                }
                this._player.teleToLocation(MapRegionManager.TeleportWhereType.Town);
                this._player.setInstanceId(0);
                this._player = null;
            }
        }
    }
}

