/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import java.util.logging.Logger;

public final class Action
extends L2GameClientPacket {
    private static final String __C__1F_ACTION = "[C] 1F Action";
    private static final Logger _log = Logger.getLogger(Action.class.getName());
    private int _objectId;
    private int _originX;
    private int _originY;
    private int _originZ;
    private int _actionId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._originX = this.readD();
        this._originY = this.readD();
        this._originZ = this.readD();
        this._actionId = this.readC();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar;
        if (Config.DEBUG) {
            _log.fine("Action:" + this._actionId);
        }
        if (Config.DEBUG) {
            _log.fine("oid:" + this._objectId);
        }
        if ((activeChar = ((L2GameClient)this.getClient()).getActiveChar()) == null) {
            return;
        }
        if (activeChar.inObserverMode()) {
            activeChar.sendPacket(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object obj = activeChar.getTargetId() == this._objectId ? activeChar.getTarget() : (activeChar.isInAirShip() && activeChar.getAirShip().getHelmObjectId() == this._objectId ? activeChar.getAirShip() : L2World.getInstance().findObject(this._objectId));
        if (obj == null) {
            ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (obj.getInstanceId() != activeChar.getInstanceId() && activeChar.getInstanceId() != -1) {
            ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (obj instanceof L2PcInstance && ((L2PcInstance)obj).getAppearance().getInvisible() && !activeChar.isGM()) {
            ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.getActiveRequester() == null) {
            switch (this._actionId) {
                case 0: {
                    obj.onAction(activeChar);
                    break;
                }
                case 1: {
                    if (!(activeChar.isGM() || obj instanceof L2Npc && Config.ALT_GAME_VIEWNPC)) {
                        obj.onAction(activeChar, false);
                        break;
                    }
                    obj.onActionShift(activeChar);
                    break;
                }
                default: {
                    _log.warning("Character: " + activeChar.getName() + " requested invalid action: " + this._actionId);
                    ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
                    break;
                }
            }
        } else {
            ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    @Override
    public String getType() {
        return __C__1F_ACTION;
    }
}

