/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TransformManagerInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import java.util.logging.Logger;

public final class RequestAcquireSkillInfo
extends L2GameClientPacket {
    private static final String _C__73_REQUESTACQUIRESKILLINFO = "[C] 73 RequestAcquireSkillInfo";
    private static final Logger _log = Logger.getLogger(RequestAcquireSkillInfo.class.getName());
    private int _id;
    private int _level;
    private int _skillType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._id <= 0 || this._level <= 0) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Npc trainer = activeChar.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(activeChar) && !activeChar.isGM()) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        if (skill == null) {
            _log.warning(RequestAcquireSkillInfo.class.getSimpleName() + ": Skill Id: " + this._id + " level: " + this._level + " is undefined. " + RequestAcquireSkillInfo.class.getName() + " failed.");
            return;
        }
        AcquireSkillList.SkillType skillType = AcquireSkillList.SkillType.values()[this._skillType];
        if (skillType != AcquireSkillList.SkillType.Transfer && this._level > 1 && activeChar.getKnownSkill(this._id) == null || activeChar.getKnownSkill(this._id) != null && activeChar.getKnownSkill(this._id).getLevel() != this._level - 1) {
            _log.warning(RequestAcquireSkillInfo.class.getSimpleName() + ": Player " + activeChar.getName() + " is requesting info for skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!");
        }
        switch (skillType) {
            case ClassTransform: {
                L2SkillLearn s;
                if (trainer instanceof L2TransformManagerInstance) {
                    L2SkillLearn s2 = SkillTreesData.getInstance().getTransformSkill(this._id, this._level);
                    if (s2 != null) {
                        int itemId = -1;
                        int itemCount = -1;
                        int levelUpSp = s2.getLevelUpSp();
                        AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, levelUpSp, AcquireSkillList.SkillType.ClassTransform);
                        if (s2.getItemsIdCount() != null) {
                            for (int[] itemIdCount : s2.getItemsIdCount()) {
                                itemId = itemIdCount[0];
                                itemCount = itemIdCount[1];
                                if (itemId <= 0 || itemCount <= 0) continue;
                                asi.addRequirement(99, itemId, itemCount, 50);
                            }
                        }
                        this.sendPacket(asi);
                    }
                    return;
                }
                if (!trainer.getTemplate().canTeach(activeChar.getLearningClass()) || (s = SkillTreesData.getInstance().getClassSkill(this._id, this._level, activeChar.getLearningClass())) == null) break;
                int itemId = -1;
                int itemCount = -1;
                int levelUpSp = s.getCalculatedLevelUpSp(activeChar.getClassId(), activeChar.getLearningClass());
                AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, levelUpSp, AcquireSkillList.SkillType.ClassTransform);
                if (s.getItemsIdCount() != null) {
                    for (int[] itemIdCount : s.getItemsIdCount()) {
                        if (!Config.DIVINE_SP_BOOK_NEEDED && this._id == 1405) continue;
                        itemId = itemIdCount[0];
                        itemCount = itemIdCount[1];
                        if (itemId <= 0 || itemCount <= 0) continue;
                        asi.addRequirement(99, itemId, itemCount, 50);
                    }
                }
                this.sendPacket(asi);
                break;
            }
            case Fishing: {
                L2SkillLearn s = SkillTreesData.getInstance().getFishingSkill(this._id, this._level);
                if (s == null) break;
                int itemId = -1;
                int itemCount = -1;
                int levelUpSp = s.getLevelUpSp();
                AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, levelUpSp, AcquireSkillList.SkillType.Fishing);
                for (int[] itemIdCount : s.getItemsIdCount()) {
                    itemId = itemIdCount[0];
                    itemCount = itemIdCount[1];
                    if (itemId <= 0 || itemCount <= 0) continue;
                    asi.addRequirement(4, itemId, itemCount, 0);
                }
                this.sendPacket(asi);
                break;
            }
            case Pledge: {
                if (!activeChar.isClanLeader()) {
                    return;
                }
                L2SkillLearn s = SkillTreesData.getInstance().getPledgeSkill(this._id, this._level);
                if (s == null) break;
                int itemId = -1;
                int itemCount = -1;
                int requiredRep = s.getLevelUpSp();
                AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, requiredRep, AcquireSkillList.SkillType.Pledge);
                if (Config.LIFE_CRYSTAL_NEEDED) {
                    for (int[] itemIdCount : s.getItemsIdCount()) {
                        itemId = itemIdCount[0];
                        itemCount = itemIdCount[1];
                        if (itemId <= 0 || itemCount <= 0) continue;
                        asi.addRequirement(1, itemId, itemCount, 0);
                    }
                }
                this.sendPacket(asi);
                break;
            }
            case SubPledge: {
                L2SkillLearn s;
                if (!activeChar.isClanLeader()) {
                    return;
                }
                if (!(trainer instanceof L2SquadTrainer) || (s = SkillTreesData.getInstance().getSubPledgeSkill(this._id, this._level)) == null) break;
                int itemId = -1;
                int itemCount = -1;
                int levelUpSp = s.getLevelUpSp();
                AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, levelUpSp, AcquireSkillList.SkillType.SubPledge);
                for (int[] itemIdCount : s.getItemsIdCount()) {
                    itemId = itemIdCount[0];
                    itemCount = itemIdCount[1];
                    if (itemId <= 0 || itemCount <= 0) continue;
                    asi.addRequirement(0, itemId, itemCount, 0);
                }
                this.sendPacket(asi);
                break;
            }
            case SubClass: {
                L2SkillLearn s = SkillTreesData.getInstance().getSubClassSkill(this._id, this._level);
                if (s == null) break;
                int itemId = -1;
                int itemCount = -1;
                int levelUpSp = s.getLevelUpSp();
                AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, levelUpSp, AcquireSkillList.SkillType.SubClass);
                for (int[] itemIdCount : s.getItemsIdCount()) {
                    itemId = itemIdCount[0];
                    itemCount = itemIdCount[1];
                    if (itemId <= 0 || itemCount <= 0) continue;
                    asi.addRequirement(99, itemId, itemCount, 50);
                }
                this.sendPacket(asi);
                break;
            }
            case Collect: {
                L2SkillLearn s = SkillTreesData.getInstance().getCollectSkill(this._id, this._level);
                if (s == null) break;
                int itemId = -1;
                int itemCount = -1;
                int levelUpSp = s.getLevelUpSp();
                AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, levelUpSp, AcquireSkillList.SkillType.Collect);
                for (int[] itemIdCount : s.getItemsIdCount()) {
                    itemId = itemIdCount[0];
                    itemCount = itemIdCount[1];
                    if (itemId <= 0 || itemCount <= 0) continue;
                    asi.addRequirement(6, itemId, itemCount, 0);
                }
                this.sendPacket(asi);
                break;
            }
            case Transfer: {
                L2SkillLearn s = SkillTreesData.getInstance().getTransferSkill(this._id, this._level, activeChar.getClassId());
                if (s != null) {
                    int itemId = -1;
                    int itemCount = -1;
                    int levelUpSp = s.getLevelUpSp();
                    AcquireSkillInfo asi = new AcquireSkillInfo(this._id, this._level, levelUpSp, AcquireSkillList.SkillType.Transfer);
                    for (int[] itemIdCount : s.getItemsIdCount()) {
                        itemId = itemIdCount[0];
                        itemCount = itemIdCount[1];
                        if (itemId <= 0 || itemCount <= 0) continue;
                        asi.addRequirement(4, itemId, itemCount, 0);
                    }
                    this.sendPacket(asi);
                    break;
                }
                _log.warning(RequestAcquireSkillInfo.class.getSimpleName() + ": Null L2SkillLearn for id: " + this._id + " and level " + this._level + " in Transfer Skill Tree for skill learning class " + (Object)((Object)activeChar.getClassId()) + "!");
                break;
            }
        }
    }

    @Override
    public String getType() {
        return _C__73_REQUESTACQUIRESKILLINFO;
    }
}

