/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2MercManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.L2Armor;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.model.item.L2Weapon;
import com.l2jserver.gameserver.model.item.type.L2ArmorType;
import com.l2jserver.gameserver.model.item.type.L2WeaponType;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ShopPreviewInfo;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class RequestPreviewItem
extends L2GameClientPacket {
    private static final String _C__C7_REQUESTPREVIEWITEM = "[C] C7 RequestPreviewItem";
    protected static final Logger _log = Logger.getLogger(RequestPreviewItem.class.getName());
    private L2PcInstance _activeChar;
    private Map<Integer, Integer> _item_list;
    private int _unk;
    private int _listId;
    private int _count;
    private int[] _items;

    @Override
    protected void readImpl() {
        this._unk = this.readD();
        this._listId = this.readD();
        this._count = this.readD();
        if (this._count < 0) {
            this._count = 0;
        }
        if (this._count > 100) {
            return;
        }
        this._items = new int[this._count];
        for (int i = 0; i < this._count; ++i) {
            this._items[i] = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        if (this._items == null) {
            return;
        }
        this._activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (this._activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("buy")) {
            this._activeChar.sendMessage("You are buying too fast.");
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_SHOP && this._activeChar.getKarma() > 0) {
            return;
        }
        L2Object target = this._activeChar.getTarget();
        if (!(this._activeChar.isGM() || target != null && (target instanceof L2MerchantInstance || target instanceof L2MercManagerInstance) && this._activeChar.isInsideRadius(target, 150, false, false))) {
            return;
        }
        if (this._count < 1 || this._listId >= 4000000) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2TradeList list = null;
        L2MerchantInstance merchant = target instanceof L2MerchantInstance ? (L2MerchantInstance)target : null;
        List<L2TradeList> lists = TradeController.getInstance().getBuyListByNpcId(merchant.getNpcId());
        if (lists == null) {
            Util.handleIllegalPlayerAction(this._activeChar, "Warning!! Character " + this._activeChar.getName() + " of account " + this._activeChar.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        for (L2TradeList tradeList : lists) {
            if (tradeList.getListId() != this._listId) continue;
            list = tradeList;
        }
        if (list == null) {
            Util.handleIllegalPlayerAction(this._activeChar, "Warning!! Character " + this._activeChar.getName() + " of account " + this._activeChar.getAccountName() + " sent a false BuyList list_id " + this._listId, Config.DEFAULT_PUNISH);
            return;
        }
        long totalPrice = 0L;
        this._listId = list.getListId();
        this._item_list = new FastMap();
        for (int i = 0; i < this._count; ++i) {
            int slot;
            int itemId = this._items[i];
            if (!list.containsItemId(itemId)) {
                Util.handleIllegalPlayerAction(this._activeChar, "Warning!! Character " + this._activeChar.getName() + " of account " + this._activeChar.getAccountName() + " sent a false BuyList list_id " + this._listId + " and item_id " + itemId, Config.DEFAULT_PUNISH);
                return;
            }
            L2Item template = ItemTable.getInstance().getTemplate(itemId);
            if (template == null || (slot = Inventory.getPaperdollIndex(template.getBodyPart())) < 0 || (!(template instanceof L2Weapon) ? template instanceof L2Armor && this._activeChar.getRace().ordinal() == 5 && (template.getItemType() == L2ArmorType.HEAVY || template.getItemType() == L2ArmorType.MAGIC) : this._activeChar.getRace().ordinal() == 5 && (template.getItemType() == L2WeaponType.NONE || template.getItemType() == L2WeaponType.RAPIER || template.getItemType() == L2WeaponType.CROSSBOW || template.getItemType() == L2WeaponType.ANCIENTSWORD))) continue;
            if (this._item_list.containsKey(slot)) {
                this._activeChar.sendPacket(SystemMessageId.YOU_CAN_NOT_TRY_THOSE_ITEMS_ON_AT_THE_SAME_TIME);
                return;
            }
            this._item_list.put(slot, itemId);
            if ((totalPrice += (long)Config.WEAR_PRICE) <= 99900000000L) continue;
            Util.handleIllegalPlayerAction(this._activeChar, "Warning!! Character " + this._activeChar.getName() + " of account " + this._activeChar.getAccountName() + " tried to purchase over " + 99900000000L + " adena worth of goods.", Config.DEFAULT_PUNISH);
            return;
        }
        if (totalPrice < 0L || !this._activeChar.reduceAdena("Wear", totalPrice, this._activeChar.getLastFolkNPC(), true)) {
            this._activeChar.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            return;
        }
        if (!this._item_list.isEmpty()) {
            this._activeChar.sendPacket(new ShopPreviewInfo(this._item_list));
            ThreadPoolManager.getInstance().scheduleGeneral(new RemoveWearItemsTask(), Config.WEAR_DELAY * 1000);
        }
    }

    @Override
    public String getType() {
        return _C__C7_REQUESTPREVIEWITEM;
    }

    private class RemoveWearItemsTask
    implements Runnable {
        private RemoveWearItemsTask() {
        }

        @Override
        public void run() {
            try {
                RequestPreviewItem.this._activeChar.sendPacket(SystemMessageId.NO_LONGER_TRYING_ON);
                RequestPreviewItem.this._activeChar.sendPacket(new UserInfo(RequestPreviewItem.this._activeChar));
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

