/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import gnu.trove.procedure.TObjectProcedure;

public final class RequestStartPledgeWar
extends L2GameClientPacket {
    private static final String _C__03_REQUESTSTARTPLEDGEWAR = "[C] 03 RequestStartPledgewar";
    private String _pledgeName;
    private L2Clan _clan;
    private L2PcInstance player;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        this.player = ((L2GameClient)this.getClient()).getActiveChar();
        if (this.player == null) {
            return;
        }
        this._clan = ((L2GameClient)this.getClient()).getActiveChar().getClan();
        if (this._clan == null) {
            return;
        }
        if (this._clan.getLevel() < 3 || this._clan.getMembersCount() < Config.ALT_CLAN_MEMBERS_FOR_WAR) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        if ((this.player.getClanPrivileges() & 0x20) != 32) {
            this.player.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (clan == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_CANNOT_DECLARED_CLAN_NOT_EXIST);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (this._clan.getAllyId() == clan.getAllyId() && this._clan.getAllyId() != 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_AGAINST_A_ALLIED_CLAN_NOT_WORK);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        if (clan.getLevel() < 3 || clan.getMembersCount() < Config.ALT_CLAN_MEMBERS_FOR_WAR) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER);
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        if (this._clan.isAtWarWith(clan.getClanId())) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.ALREADY_AT_WAR_WITH_S1_WAIT_5_DAYS);
            sm.addString(clan.getName());
            this.player.sendPacket(sm);
            this.player.sendPacket(ActionFailed.STATIC_PACKET);
            sm = null;
            return;
        }
        ClanTable.getInstance().storeclanswars(this.player.getClanId(), clan.getClanId());
        L2World.getInstance().forEachPlayer(new ForEachPlayerBroadcastUserInfo(clan));
    }

    @Override
    public String getType() {
        return _C__03_REQUESTSTARTPLEDGEWAR;
    }

    private final class ForEachPlayerBroadcastUserInfo
    implements TObjectProcedure<L2PcInstance> {
        L2Clan _cln;

        private ForEachPlayerBroadcastUserInfo(L2Clan clan) {
            this._cln = clan;
        }

        public final boolean execute(L2PcInstance cha) {
            if (cha.getClan() == RequestStartPledgeWar.this.player.getClan() || cha.getClan() == this._cln) {
                cha.broadcastUserInfo();
            }
            return true;
        }
    }
}

