/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import gnu.trove.procedure.TObjectProcedure;

public final class RequestStopPledgeWar
extends L2GameClientPacket {
    private static final String _C__05_REQUESTSTOPPLEDGEWAR = "[C] 05 RequestStopPledgeWar";
    private String _pledgeName;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2Clan playerClan = player.getClan();
        if (playerClan == null) {
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (clan == null) {
            player.sendMessage("No such clan.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!playerClan.isAtWarWith(clan.getClanId())) {
            player.sendMessage("You aren't at war with this clan.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if ((player.getClanPrivileges() & 0x20) != 32) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            return;
        }
        for (L2ClanMember member : playerClan.getMembers()) {
            if (member == null || member.getPlayerInstance() == null || !AttackStanceTaskManager.getInstance().getAttackStanceTask(member.getPlayerInstance())) continue;
            player.sendPacket(SystemMessageId.CANT_STOP_CLAN_WAR_WHILE_IN_COMBAT);
            return;
        }
        ClanTable.getInstance().deleteclanswars(playerClan.getClanId(), clan.getClanId());
        L2World.getInstance().forEachPlayer(new ForEachPlayerBroadcastUserInfo(clan, player));
    }

    @Override
    public String getType() {
        return _C__05_REQUESTSTOPPLEDGEWAR;
    }

    private final class ForEachPlayerBroadcastUserInfo
    implements TObjectProcedure<L2PcInstance> {
        L2PcInstance _player;
        L2Clan _cln;

        private ForEachPlayerBroadcastUserInfo(L2Clan clan, L2PcInstance player) {
            this._cln = clan;
            this._player = player;
        }

        public final boolean execute(L2PcInstance cha) {
            if (cha.getClan() == this._player.getClan() || cha.getClan() == this._cln) {
                cha.broadcastUserInfo();
            }
            return true;
        }
    }
}

