/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javolution.util.FastList;

public class FriendListExtended
extends L2GameServerPacket {
    private static final String _S__FA_FRIENDLISTEXTENDED = "[S] 75 FriendListExtended";
    private final List<FriendInfo> _info;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FriendListExtended(L2PcInstance player) {
        this._info = new FastList(player.getFriendList().size());
        for (int objId : player.getFriendList()) {
            String name = CharNameTable.getInstance().getNameById(objId);
            L2PcInstance player1 = L2World.getInstance().getPlayer(objId);
            boolean online = false;
            int classid = 0;
            int level = 0;
            if (player1 == null) {
                Connection con = null;
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    PreparedStatement statement = con.prepareStatement("SELECT char_name, online, classid, level FROM characters WHERE charId = ?");
                    statement.setInt(1, objId);
                    ResultSet rset = statement.executeQuery();
                    if (!rset.next()) continue;
                    this._info.add(new FriendInfo(objId, rset.getString(1), rset.getInt(2) == 1, rset.getInt(3), rset.getInt(4)));
                }
                catch (Exception e) {}
                continue;
                finally {
                    L2DatabaseFactory.close(con);
                    continue;
                }
            }
            if (player1.isOnline()) {
                online = true;
            }
            classid = player1.getClassId().getId();
            level = player1.getLevel();
            this._info.add(new FriendInfo(objId, name, online, classid, level));
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(88);
        this.writeD(this._info.size());
        for (FriendInfo info : this._info) {
            this.writeD(info.objId);
            this.writeS(info.name);
            this.writeD(info.online ? 1 : 0);
            this.writeD(info.online ? info.objId : 0);
            this.writeD(info.classid);
            this.writeD(info.level);
        }
    }

    @Override
    public String getType() {
        return _S__FA_FRIENDLISTEXTENDED;
    }

    private static class FriendInfo {
        int objId;
        String name;
        boolean online;
        int classid;
        int level;

        public FriendInfo(int objId, String name, boolean online, int classid, int level) {
            this.objId = objId;
            this.name = name;
            this.online = online;
            this.classid = classid;
            this.level = level;
        }
    }
}

