/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class GMViewWarehouseWithdrawList
extends L2GameServerPacket {
    private static final String _S__95_GMViewWarehouseWithdrawList = "[S] 9b GMViewWarehouseWithdrawList";
    private L2ItemInstance[] _items;
    private String _playerName;
    private L2PcInstance _activeChar;
    private long _money;

    public GMViewWarehouseWithdrawList(L2PcInstance cha) {
        this._activeChar = cha;
        this._items = this._activeChar.getWarehouse().getItems();
        this._playerName = this._activeChar.getName();
        this._money = this._activeChar.getWarehouse().getAdena();
    }

    public GMViewWarehouseWithdrawList(L2Clan clan) {
        this._playerName = clan.getLeaderName();
        this._items = clan.getWarehouse().getItems();
        this._money = clan.getWarehouse().getAdena();
    }

    @Override
    protected final void writeImpl() {
        this.writeC(155);
        this.writeS(this._playerName);
        this.writeQ(this._money);
        this.writeH(this._items.length);
        for (L2ItemInstance item : this._items) {
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeD(item.getLocationSlot());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeH(item.isEquipped() ? 1 : 0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(item.getCustomType2());
            if (item.isAugmented()) {
                this.writeD(item.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(item.getMana());
            this.writeD(item.isTimeLimitedItem() ? (int)(item.getRemainingTime() / 1000L) : -9999);
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeD(item.getObjectId());
        }
    }

    @Override
    public String getType() {
        return _S__95_GMViewWarehouseWithdrawList;
    }
}

