/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SystemMessage
extends L2GameServerPacket {
    private static final Logger _log = Logger.getLogger(SystemMessage.class.getName());
    private static final SMParam[] EMPTY_PARAM_ARRAY = new SMParam[0];
    private static final byte TYPE_SYSTEM_STRING = 13;
    private static final byte TYPE_PLAYER_NAME = 12;
    private static final byte TYPE_INSTANCE_NAME = 10;
    private static final byte TYPE_ELEMENT_NAME = 9;
    private static final byte TYPE_ZONE_NAME = 7;
    private static final byte TYPE_ITEM_NUMBER = 6;
    private static final byte TYPE_CASTLE_NAME = 5;
    private static final byte TYPE_SKILL_NAME = 4;
    private static final byte TYPE_ITEM_NAME = 3;
    private static final byte TYPE_NPC_NAME = 2;
    private static final byte TYPE_NUMBER = 1;
    private static final byte TYPE_TEXT = 0;
    private final SystemMessageId _smId;
    private SMParam[] _params;
    private int _paramIndex;

    public static final SystemMessage sendString(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1);
        sm.addString(text);
        return sm;
    }

    public static final SystemMessage getSystemMessage(SystemMessageId smId) {
        SystemMessage sm = smId.getStaticSystemMessage();
        if (sm != null) {
            return sm;
        }
        sm = new SystemMessage(smId);
        if (smId.getParamCount() == 0) {
            smId.setStaticSystemMessage(sm);
        }
        return sm;
    }

    public static SystemMessage getSystemMessage(int id) {
        return SystemMessage.getSystemMessage(SystemMessageId.getSystemMessageId(id));
    }

    private SystemMessage(SystemMessageId smId) {
        int paramCount = smId.getParamCount();
        this._smId = smId;
        this._params = paramCount != 0 ? new SMParam[paramCount] : EMPTY_PARAM_ARRAY;
    }

    @Deprecated
    private SystemMessage(int id) {
        this(SystemMessageId.getSystemMessageId(id));
    }

    private final SystemMessage append(SMParam param) {
        if (this._paramIndex >= this._params.length) {
            this._params = Arrays.copyOf(this._params, this._paramIndex + 1);
            this._smId.setParamCount(this._paramIndex + 1);
            _log.log(Level.INFO, "Wrong parameter count '" + (this._paramIndex + 1) + "' for SystemMessageId: " + this._smId);
        }
        this._params[this._paramIndex++] = param;
        return this;
    }

    public final SystemMessage addString(String text) {
        return this.append(new SMParam(0, text));
    }

    public final SystemMessage addCastleName(Castle castle) {
        return this.addCastleName(castle.getCastleId());
    }

    public final SystemMessage addClanHallName(ClanHall clanHall) {
        return this.addCastleName(clanHall.getId());
    }

    public final SystemMessage addSiegableHallName(SiegableHall siegableHall) {
        return this.addCastleName(siegableHall.getId());
    }

    public final SystemMessage addFortName(Fort fort) {
        return this.addCastleName(fort.getFortId());
    }

    private final SystemMessage addCastleName(int number) {
        return this.append(new SMParam(5, number));
    }

    public final SystemMessage addNumber(int number) {
        return this.append(new SMParam(1, number));
    }

    public final SystemMessage addItemNumber(long number) {
        return this.append(new SMParam(6, number));
    }

    public SystemMessage addNumber(long number) {
        if (Integer.MIN_VALUE <= number && number <= Integer.MAX_VALUE) {
            return this.addNumber((int)number);
        }
        return this.addItemNumber(number);
    }

    public final SystemMessage addCharName(L2Character cha) {
        if (cha instanceof L2Npc) {
            if (((L2Npc)cha).getTemplate().isServerSideName()) {
                return this.addString(((L2Npc)cha).getTemplate().getName());
            }
            return this.addNpcName((L2Npc)cha);
        }
        if (cha instanceof L2PcInstance) {
            return this.addPcName((L2PcInstance)cha);
        }
        if (cha instanceof L2Summon) {
            if (((L2Summon)cha).getTemplate().isServerSideName()) {
                return this.addString(((L2Summon)cha).getTemplate().getName());
            }
            return this.addNpcName((L2Summon)cha);
        }
        return this.addString(cha.getName());
    }

    public final SystemMessage addPcName(L2PcInstance pc) {
        return this.append(new SMParam(12, pc.getAppearance().getVisibleName()));
    }

    public final SystemMessage addNpcName(L2Npc npc) {
        return this.addNpcName(npc.getTemplate());
    }

    public final SystemMessage addNpcName(L2Summon npc) {
        return this.addNpcName(npc.getNpcId());
    }

    public final SystemMessage addNpcName(L2NpcTemplate template) {
        if (template.isCustom()) {
            return this.addString(template.getName());
        }
        return this.addNpcName(template.getNpcId());
    }

    public final SystemMessage addNpcName(int id) {
        return this.append(new SMParam(2, 1000000 + id));
    }

    public final SystemMessage addItemName(L2ItemInstance item) {
        return this.addItemName(item.getItem().getItemId());
    }

    public final SystemMessage addItemName(L2Item item) {
        return this.addItemName(item.getItemId());
    }

    public final SystemMessage addItemName(int id) {
        return this.append(new SMParam(3, id));
    }

    public final SystemMessage addZoneName(int x, int y, int z) {
        return this.append(new SMParam(7, new int[]{x, y, z}));
    }

    public final SystemMessage addSkillName(L2Effect effect) {
        return this.addSkillName(effect.getSkill());
    }

    public final SystemMessage addSkillName(L2Skill skill) {
        if (skill.getId() != skill.getDisplayId()) {
            return this.addString(skill.getName());
        }
        return this.addSkillName(skill.getId(), skill.getLevel());
    }

    public final SystemMessage addSkillName(int id) {
        return this.addSkillName(id, 1);
    }

    public final SystemMessage addSkillName(int id, int lvl) {
        return this.append(new SMParam(4, new int[]{id, lvl}));
    }

    public final SystemMessage addElemental(int type) {
        return this.append(new SMParam(9, type));
    }

    public final SystemMessage addSystemString(int type) {
        return this.append(new SMParam(13, type));
    }

    public final SystemMessage addInstanceName(int type) {
        return this.append(new SMParam(10, type));
    }

    public final SystemMessageId getSystemMessageId() {
        return this._smId;
    }

    public final SystemMessage getLocalizedMessage(String lang) {
        if (!Config.L2JMOD_MULTILANG_SM_ENABLE || this._smId == SystemMessageId.S1) {
            return this;
        }
        SystemMessageId.SMLocalisation sml = this._smId.getLocalisation(lang);
        if (sml == null) {
            return this;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1);
        Object[] params = new Object[this._paramIndex];
        block13: for (int i = 0; i < this._paramIndex; ++i) {
            SMParam param = this._params[i];
            switch (param.getType()) {
                case 0: 
                case 12: {
                    params[i] = param.getValue();
                    continue block13;
                }
                case 6: {
                    params[i] = param.getValue();
                    continue block13;
                }
                case 3: {
                    L2Item item = ItemTable.getInstance().getTemplate(param.getIntValue());
                    params[i] = item == null ? "Unknown" : item.getName();
                    continue block13;
                }
                case 5: {
                    Castle castle = CastleManager.getInstance().getCastleById(param.getIntValue());
                    params[i] = castle == null ? "Unknown" : castle.getName();
                    continue block13;
                }
                case 1: {
                    params[i] = param.getValue();
                    continue block13;
                }
                case 2: {
                    L2NpcTemplate template = NpcTable.getInstance().getTemplate(param.getIntValue());
                    params[i] = template == null ? "Unknown" : template.getName();
                    continue block13;
                }
                case 9: {
                    params[i] = Elementals.getElementName((byte)param.getIntValue());
                    continue block13;
                }
                case 13: {
                    params[i] = "SYS-S-" + param.getIntValue();
                    continue block13;
                }
                case 10: {
                    params[i] = "INS-N-" + param.getIntValue();
                    continue block13;
                }
                case 4: {
                    int[] array = param.getIntArrayValue();
                    L2Skill skill = SkillTable.getInstance().getInfo(array[0], array[1]);
                    params[i] = skill == null ? "Unknown" : skill.getName();
                    continue block13;
                }
                case 7: {
                    int[] array = param.getIntArrayValue();
                    params[i] = "ZON-N-" + Arrays.toString(array);
                    continue block13;
                }
            }
        }
        sm.addString(sml.getLocalisation(params));
        return sm;
    }

    public final void printMe(PrintStream out) {
        out.println(98);
        out.println(this._smId.getId());
        out.println(this._paramIndex);
        block7: for (int i = 0; i < this._paramIndex; ++i) {
            SMParam param = this._params[i];
            out.println(param.getType());
            switch (param.getType()) {
                case 0: 
                case 12: {
                    out.println(param.getStringValue());
                    continue block7;
                }
                case 6: {
                    out.println(param.getLongValue());
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: 
                case 10: 
                case 13: {
                    out.println(param.getIntValue());
                    continue block7;
                }
                case 4: {
                    int[] array = param.getIntArrayValue();
                    out.println(array[0]);
                    out.println(array[1]);
                    continue block7;
                }
                case 7: {
                    int[] array = param.getIntArrayValue();
                    out.println(array[0]);
                    out.println(array[1]);
                    out.println(array[2]);
                    continue block7;
                }
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(98);
        this.writeD(this._smId.getId());
        this.writeD(this._paramIndex);
        block7: for (int i = 0; i < this._paramIndex; ++i) {
            SMParam param = this._params[i];
            this.writeD(param.getType());
            switch (param.getType()) {
                case 0: 
                case 12: {
                    this.writeS(param.getStringValue());
                    continue block7;
                }
                case 6: {
                    this.writeQ(param.getLongValue());
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 9: 
                case 10: 
                case 13: {
                    this.writeD(param.getIntValue());
                    continue block7;
                }
                case 4: {
                    int[] array = param.getIntArrayValue();
                    this.writeD(array[0]);
                    this.writeD(array[1]);
                    continue block7;
                }
                case 7: {
                    int[] array = param.getIntArrayValue();
                    this.writeD(array[0]);
                    this.writeD(array[1]);
                    this.writeD(array[2]);
                    continue block7;
                }
            }
        }
    }

    @Override
    public final String getType() {
        return "[S] 0x62 SystemMessage".intern();
    }

    private static final class SMParam {
        private final byte _type;
        private final Object _value;

        public SMParam(byte type, Object value) {
            this._type = type;
            this._value = value;
        }

        public final byte getType() {
            return this._type;
        }

        public final Object getValue() {
            return this._value;
        }

        public final String getStringValue() {
            return (String)this._value;
        }

        public final int getIntValue() {
            return (Integer)this._value;
        }

        public final long getLongValue() {
            return (Long)this._value;
        }

        public final int[] getIntArrayValue() {
            return (int[])this._value;
        }
    }
}

