/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserNotCreatedException;
import com.l2jserver.gameserver.script.ScriptDocument;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.util.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import org.w3c.dom.Node;

public class FaenorScriptEngine
extends ScriptEngine {
    static Logger _log = Logger.getLogger(FaenorScriptEngine.class.getName());
    public static final String PACKAGE_DIRECTORY = "data/faenor/";
    public static final boolean DEBUG = true;

    public static FaenorScriptEngine getInstance() {
        return SingletonHolder._instance;
    }

    private FaenorScriptEngine() {
        File packDirectory = new File(Config.DATAPACK_ROOT, PACKAGE_DIRECTORY);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".xml");
            }
        };
        File[] files = packDirectory.listFiles(fileFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                _log.info("FaenorScriptEngine: " + file.getPath());
                FileInputStream in = new FileInputStream(file);
                this.parseScript(new ScriptDocument(file.getName(), in), null);
                ((InputStream)in).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void parseScript(ScriptDocument script, ScriptContext context) {
        _log.fine("Parsing Script: " + script.getName());
        Node node = script.getDocument().getFirstChild();
        String parserClass = "faenor.Faenor" + node.getNodeName() + "Parser";
        Parser parser = null;
        try {
            parser = FaenorScriptEngine.createParser(parserClass);
        }
        catch (ParserNotCreatedException e) {
            _log.log(Level.WARNING, "ERROR: No parser registered for Script: " + parserClass + ": " + e.getMessage(), e);
        }
        if (parser == null) {
            _log.warning("Unknown Script Type: " + script.getName());
            return;
        }
        try {
            parser.parseScript(node, context);
            _log.fine(script.getName() + "Script Sucessfullty Parsed.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Script Parsing Failed: " + e.getMessage(), e);
        }
    }

    public void dump() {
        System.out.println("FaenorScriptEngine:");
        for (EventDroplist.DateDrop drop : EventDroplist.getInstance().getAllDrops()) {
            System.out.println("  Active=" + Util.dateFormat(drop.dateRange.getStartDate()) + "-" + Util.dateFormat(drop.dateRange.getEndDate()));
            System.out.println("  Count=" + drop.min + "," + drop.max + " Chance=" + (double)drop.chance * 100.0 / 1000000.0 + "%");
            for (int itemId : drop.items) {
                L2Item i = ItemTable.getInstance().getTemplate(itemId);
                System.out.println("    Item=" + itemId + " " + (i == null ? "NULL" : i.getName()));
            }
        }
    }

    private static class SingletonHolder {
        protected static final FaenorScriptEngine _instance = new FaenorScriptEngine();

        private SingletonHolder() {
        }
    }
}

