/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.IhaveOwner;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TotemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.logging.Level;

public class L2SkillSpawn
extends L2Skill {
    private final int _npcId;
    private final int _despawnDelay;
    private final boolean _summonSpawn;
    private final boolean _randomOffset;
    private final int _skillToCast;
    private final boolean _showOwnerName;

    public L2SkillSpawn(StatsSet set) {
        super(set);
        this._npcId = set.getInteger("npcId", 0);
        this._despawnDelay = set.getInteger("despawnDelay", 0);
        this._summonSpawn = set.getBool("isSummonSpawn", false);
        this._randomOffset = set.getBool("randomOffset", true);
        this._skillToCast = set.getInteger("skillToCast", 0);
        this._showOwnerName = set.getBool("showOwnerName", true);
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        if (caster.isAlikeDead()) {
            return;
        }
        if (this._npcId == 0) {
            _log.warning("NPC ID not defined for skill ID:" + this.getId());
            return;
        }
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(this._npcId);
        if (template == null) {
            _log.warning("Spawn of the nonexisting NPC ID:" + this._npcId + ", skill ID:" + this.getId());
            return;
        }
        try {
            int h;
            int y;
            int x;
            L2Spawn spawn = new L2Spawn(template);
            spawn.setInstanceId(caster.getInstanceId());
            if (this._randomOffset) {
                double radius = 20.0 + 30.0 * Rnd.nextDouble();
                double angle = Math.PI * 2 * Rnd.nextDouble();
                x = caster.getX() + (int)(radius * Math.cos(angle));
                y = caster.getY() + (int)(radius * Math.sin(angle));
                h = (int)((angle + Math.PI) / (Math.PI * 2) * 65536.0) % 65536;
            } else {
                x = caster.getX();
                y = caster.getY();
                h = caster.getHeading();
            }
            spawn.setLocx(x);
            spawn.setLocy(y);
            spawn.setLocz(caster.getZ() + 20);
            spawn.setHeading(h);
            spawn.stopRespawn();
            L2Npc npc = spawn.spawnOne(this._summonSpawn);
            if (this._despawnDelay > 0) {
                npc.scheduleDespawn(this._despawnDelay);
            }
            if (npc instanceof IhaveOwner) {
                ((IhaveOwner)((Object)npc)).setOwner((L2PcInstance)caster);
            }
            if (npc instanceof L2TotemInstance) {
                ((L2TotemInstance)npc).startAITask(this._skillToCast);
            }
            if (this._showOwnerName) {
                npc.setTitle(caster.getName());
                npc.broadcastPacket(new AbstractNpcInfo.NpcInfo(npc, null));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception while spawning NPC ID: " + this._npcId + ", skill ID: " + this.getId() + ", exception: " + e.getMessage(), e);
        }
    }
}

