/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskDailyQuestClean
extends Task {
    private static final Logger _log = Logger.getLogger(TaskDailyQuestClean.class.getName());
    private static final String NAME = "daily_quest_clean";
    private static final String[] _daily_names = new String[]{"463_IMustBeaGenius", "464_Oath", "458_PerfectForm", "461_RumbleInTheBase", "551_OlympiadStarter", "552_OlympiadVeteran", "553_OlympiadUndefeated"};

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            for (String name : _daily_names) {
                PreparedStatement statement = con.prepareStatement("DELETE FROM character_quests WHERE name=? AND var='<state>' AND value='Completed';");
                statement.setString(1, name);
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not reset daily quests: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.config("Daily quests cleared");
    }

    @Override
    public void initializate() {
        super.initializate();
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

