/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import java.io.Serializable;

public class Point3D
implements Serializable {
    private static final long serialVersionUID = 4638345252031872576L;
    private volatile int _x;
    private volatile int _y;
    private volatile int _z;

    public Point3D(int pX, int pY, int pZ) {
        this._x = pX;
        this._y = pY;
        this._z = pZ;
    }

    public Point3D(int pX, int pY) {
        this._x = pX;
        this._y = pY;
        this._z = 0;
    }

    public Point3D(Point3D worldPosition) {
        this._x = worldPosition._x;
        this._y = worldPosition._y;
        this._z = worldPosition._z;
    }

    public synchronized void setTo(Point3D point) {
        this._x = point._x;
        this._y = point._y;
        this._z = point._z;
    }

    public String toString() {
        return "(" + this._x + ", " + this._y + ", " + this._z + ")";
    }

    public int hashCode() {
        return this._x ^ this._y ^ this._z;
    }

    public boolean equals(Object o) {
        if (o instanceof Point3D) {
            Point3D point3D = (Point3D)o;
            boolean ret = point3D._x == this._x && point3D._y == this._y && point3D._z == this._z;
            return ret;
        }
        return false;
    }

    public boolean equals(int pX, int pY, int pZ) {
        return this._x == pX && this._y == pY && this._z == pZ;
    }

    public long distanceSquaredTo(Point3D point) {
        long dx = this._x - point._x;
        long dy = this._y - point._y;
        return dx * dx + dy * dy;
    }

    public static long distanceSquared(Point3D point1, Point3D point2) {
        long dx = point1._x - point2._x;
        long dy = point1._y - point2._y;
        return dx * dx + dy * dy;
    }

    public static boolean distanceLessThan(Point3D point1, Point3D point2, double distance) {
        return (double)Point3D.distanceSquared(point1, point2) < distance * distance;
    }

    public int getX() {
        return this._x;
    }

    public synchronized void setX(int pX) {
        this._x = pX;
    }

    public int getY() {
        return this._y;
    }

    public synchronized void setY(int pY) {
        this._y = pY;
    }

    public int getZ() {
        return this._z;
    }

    public synchronized void setZ(int pZ) {
        this._z = pZ;
    }

    public synchronized void setXYZ(int pX, int pY, int pZ) {
        this._x = pX;
        this._y = pY;
        this._z = pZ;
    }
}

