/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.ngl;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class LocalizationParser {
    private String LANGUAGES_DIRECTORY = "../languages/";
    private Map<String, String> _msgMap = new HashMap<String, String>();
    private static final Logger _log = Logger.getLogger(LocalizationParser.class.getName());
    private String _baseName;

    public LocalizationParser(String dir, String baseName, Locale locale) {
        this.LANGUAGES_DIRECTORY = this.LANGUAGES_DIRECTORY + dir + "/";
        this._baseName = baseName;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder sb = new StringBuilder(256);
        sb.append(language);
        if (country != "") {
            sb.append(country);
        }
        if (variant != "") {
            sb.append('_' + variant);
        }
        File xml = this.getTranslationFile(sb.toString());
        this.parseXml(xml);
    }

    public LocalizationParser(String dir, String baseName, String locale) {
        this.LANGUAGES_DIRECTORY = this.LANGUAGES_DIRECTORY + dir + "/";
        this._baseName = baseName;
        File xml = this.getTranslationFile(locale);
        this.parseXml(xml);
    }

    private void parseXml(File xml) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        Document doc = null;
        if (xml.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(xml);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not load localization file");
            }
            Node n = doc.getFirstChild();
            NamedNodeMap docAttr = n.getAttributes();
            if (docAttr.getNamedItem("extends") != null) {
                String baseLang = docAttr.getNamedItem("extends").getNodeValue();
                this.parseXml(this.getTranslationFile(baseLang));
            }
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!d.getNodeName().equals("message")) continue;
                NamedNodeMap attrs = d.getAttributes();
                String id = attrs.getNamedItem("id").getNodeValue();
                String text = attrs.getNamedItem("text").getNodeValue();
                this._msgMap.put(id, text);
            }
        }
    }

    private File getTranslationFile(String language) {
        File xml = null;
        if (language.length() > 0) {
            xml = new File(this.LANGUAGES_DIRECTORY + this._baseName + '_' + language + ".xml");
        }
        if (!(language.length() <= 2 || xml != null && xml.exists())) {
            xml = new File(this.LANGUAGES_DIRECTORY + this._baseName + '_' + language.substring(0, 2) + ".xml");
        }
        if (xml == null || !xml.exists()) {
            xml = new File(this.LANGUAGES_DIRECTORY + this._baseName + ".xml");
        }
        return xml;
    }

    protected String getStringFromId(String id) {
        return this._msgMap.get(id);
    }
}

