/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.Shutdown;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeadLockDetector
extends Thread {
    private static Logger _log = Logger.getLogger(DeadLockDetector.class.getName());
    private static final int _sleepTime = Config.DEADLOCK_CHECK_INTERVAL * 1000;
    private final ThreadMXBean tmx = ManagementFactory.getThreadMXBean();

    public DeadLockDetector() {
        super("DeadLockDetector");
    }

    @Override
    public final void run() {
        boolean deadlock = false;
        while (!deadlock) {
            try {
                long[] ids = this.tmx.findDeadlockedThreads();
                if (ids != null) {
                    deadlock = true;
                    ThreadInfo[] tis = this.tmx.getThreadInfo(ids, true, true);
                    StringBuilder info = new StringBuilder(256).append("DeadLock Found!\n");
                    for (ThreadInfo ti : tis) {
                        info.append(ti.toString());
                    }
                    for (ThreadInfo ti : tis) {
                        LockInfo[] locks = ti.getLockedSynchronizers();
                        MonitorInfo[] monitors = ti.getLockedMonitors();
                        if (locks.length == 0 && monitors.length == 0) continue;
                        ThreadInfo dl = ti;
                        info.append("Java-level deadlock:\n").append('\t').append(dl.getThreadName()).append(" is waiting to lock ").append(dl.getLockInfo().toString()).append(" which is held by ").append(dl.getLockOwnerName()).append('\n');
                        while ((dl = this.tmx.getThreadInfo(new long[]{dl.getLockOwnerId()}, true, true)[0]).getThreadId() != ti.getThreadId()) {
                            info.append('\t').append(dl.getThreadName()).append(" is waiting to lock ").append(dl.getLockInfo().toString()).append(" which is held by ").append(dl.getLockOwnerName()).append('\n');
                        }
                    }
                    _log.warning(info.toString());
                    if (Config.RESTART_ON_DEADLOCK) {
                        Announcements an = Announcements.getInstance();
                        an.announceToAll("Server has stability issues - restarting now.");
                        Shutdown.getInstance().startTelnetShutdown("DeadLockDetector - Auto Restart", 60, true);
                    }
                }
                Thread.sleep(_sleepTime);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "DeadLockDetector: ", e);
            }
        }
    }
}

