/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import com.l2jserver.util.Rnd;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javolution.io.UTF8StreamReader;
import javolution.io.UTF8StreamWriter;

public class Util {
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm (E)";

    public static boolean isInternalHostname(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr.isSiteLocalAddress() || addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String printData(byte[] data, int len) {
        int t1;
        int a;
        int charpoint;
        StringBuilder result = new StringBuilder(len * 4);
        int counter = 0;
        for (int i = 0; i < len; ++i) {
            if (counter % 16 == 0) {
                result.append(Util.fillHex(i, 4)).append(": ");
            }
            result.append(Util.fillHex(data[i] & 0xFF, 2)).append(' ');
            if (++counter != 16) continue;
            result.append("   ");
            charpoint = i - 15;
            for (a = 0; a < 16; ++a) {
                if ((t1 = 0xFF & data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append('\n');
            counter = 0;
        }
        int rest = data.length % 16;
        if (rest > 0) {
            for (int i = 0; i < 17 - rest; ++i) {
                result.append("   ");
            }
            charpoint = data.length - rest;
            for (a = 0; a < rest; ++a) {
                if ((t1 = 0xFF & data[charpoint++]) > 31 && t1 < 128) {
                    result.append((char)t1);
                    continue;
                }
                result.append('.');
            }
            result.append('\n');
        }
        return result.toString();
    }

    private static String fillHex(int data, int digits) {
        String number = Integer.toHexString(data);
        for (int i = number.length(); i < digits; ++i) {
            number = "0" + number;
        }
        return number;
    }

    public static String printData(byte[] data) {
        return Util.printData(data, data.length);
    }

    public static String printData(ByteBuffer buf) {
        byte[] data = new byte[buf.remaining()];
        buf.get(data);
        String hex = Util.printData(data, data.length);
        buf.position(buf.position() - data.length);
        return hex;
    }

    public static byte[] generateHex(int size) {
        byte[] array = new byte[size];
        Rnd.nextBytes(array);
        return array;
    }

    public static String dateFormat() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    public static String dateFormat(long d) {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date(d));
    }

    public static String dateFormat(Date d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d);
    }

    public static String dateFormat(Calendar d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d.getTime());
    }

    public static String strTimeLeft(int time) {
        if (time % 86400 == 0) {
            return time / 86400 + "\u65e5\u9593";
        }
        if (time % 3600 == 0) {
            return time / 3600 + "\u6642\u9593";
        }
        if (time % 60 == 0) {
            return time / 60 + "\u5206\u9593";
        }
        return time + "\u79d2\u9593";
    }

    public static String strTime(int time) {
        if (time == 0) {
            return "0\u79d2";
        }
        StringBuilder sb = new StringBuilder(256);
        long n = time / 86400;
        if (n > 0L) {
            sb.append(n).append('\u65e5');
            time %= 86400;
        }
        if ((n = (long)(time / 3600)) > 0L) {
            sb.append(n).append("\u6642\u9593");
            time %= 3600;
        }
        if ((n = (long)(time / 60)) > 0L) {
            sb.append(n).append('\u5206');
            time %= 60;
        }
        if ((n = (long)time) > 0L) {
            sb.append(n).append('\u79d2');
        }
        return sb.toString();
    }

    public static String strMillTime(long milliTime) {
        if (milliTime == 0L) {
            return milliTime + "0\u79d2";
        }
        if (milliTime <= 999L) {
            return milliTime + "\u3349\u79d2";
        }
        return Util.strTime((int)((milliTime + 999L) / 1000L));
    }

    public static BufferedReader utf8BufferedReader(String name) throws FileNotFoundException {
        return Util.skipBOM(new BufferedReader((Reader)new UTF8StreamReader().setInput((InputStream)new FileInputStream(name))));
    }

    public static BufferedReader utf8BufferedReader(File file) throws FileNotFoundException {
        return Util.skipBOM(new BufferedReader((Reader)new UTF8StreamReader().setInput((InputStream)new FileInputStream(file))));
    }

    public static UTF8StreamWriter utf8StreamWriter(String name) throws FileNotFoundException {
        return new UTF8StreamWriter().setOutput((OutputStream)new FileOutputStream(name));
    }

    public static UTF8StreamWriter utf8StreamWriter(String name, boolean flag) throws FileNotFoundException {
        return new UTF8StreamWriter().setOutput((OutputStream)new FileOutputStream(name, flag));
    }

    public static UTF8StreamWriter utf8StreamWriter(File file) throws FileNotFoundException {
        return new UTF8StreamWriter().setOutput((OutputStream)new FileOutputStream(file));
    }

    private static BufferedReader skipBOM(BufferedReader reader) {
        try {
            reader.mark(1);
            if (reader.read() != 65279) {
                reader.reset();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reader;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

