/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.actionhandlers;

import com.l2jserver.gameserver.handler.IActionHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Object.InstanceType;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.StaticObject;

public class L2DoorInstanceActionShift implements IActionHandler
{
	public boolean action(L2PcInstance activeChar, L2Object target, boolean interact)
	{
		if (activeChar.getAccessLevel().isGm())
		{
			L2DoorInstance door = (L2DoorInstance)target;
			
			activeChar.setTarget(door);
			activeChar.sendPacket(new MyTargetSelected(door.getObjectId(), activeChar.getLevel()));
			
			StaticObject su;
			// send HP amount if doors are inside castle/fortress zone

			if ((door.getCastle() != null && door.getCastle().getCastleId() > 0)
				|| (door.getFort() != null && door.getFort().getFortId() > 0
				|| (door.getClanHall() != null && door.getClanHall().isSiegableHall())
				&& !door.getIsCommanderDoor()))
			{
				su = new StaticObject(door, true);
			}
			else
			{
				su  = new StaticObject(door, false);
			}
			
			activeChar.sendPacket(su);
			
			NpcHtmlMessage html = new NpcHtmlMessage(0);
			html.setFile(activeChar.getHtmlPrefix(), "data/html/admin/doorinfo.htm");
			html.replace("%class%", door.getClass().getSimpleName());
			html.replace("%hp%",    (int)door.getCurrentHp());
			html.replace("%hpmax%", door.getMaxHp());
			html.replace("%objid%", door.getObjectId());
			html.replace("%doorid%",  door.getDoorId());
			
			html.replace("%minx%", door.getXMin());
			html.replace("%miny%", door.getYMin());
			html.replace("%minz%", door.getZMin());
			
			html.replace("%maxx%", door.getXMax());
			html.replace("%maxy%", door.getYMax());
			html.replace("%maxz%", door.getZMax());
			html.replace("%unlock%", door.isUnlockable() ? "<font color=00FF00>YES<font>" : "<font color=FF0000>NO</font>");
			
			activeChar.sendPacket(html);
		}
		return true;
	}
	
	public InstanceType getInstanceType()
	{
		return InstanceType.L2DoorInstance;
	}
}